/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.mvc;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.module.mvc.IBaseService;
import com.iteaj.util.module.mvc.orm.Entity;
import com.iteaj.util.module.mvc.orm.IBaseDao;
import com.iteaj.util.module.mvc.result.BooleanResult;
import com.iteaj.util.module.mvc.result.DetailResult;
import com.iteaj.util.module.mvc.result.ListResult;
import com.iteaj.util.module.mvc.result.PageResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseServiceImpl<D extends IBaseDao<E>, E extends Entity>
implements IBaseService<D, E> {
    private D baseDao;

    @Override
    public BooleanResult insert(E entity) {
        boolean b = this.getBaseDao().insert(entity) > 0;
        return new BooleanResult(b);
    }

    @Override
    public BooleanResult insertAsBatch(List<E> entityList) {
        if (!CommonUtils.isNotEmpty(entityList)) {
            return new BooleanResult(false);
        }
        int i = this.baseDao.insertAsBatch(entityList);
        return new BooleanResult(i == entityList.size());
    }

    @Override
    public BooleanResult deleteById(Serializable id) {
        boolean b = this.getBaseDao().deleteById(id) > 0;
        return new BooleanResult(b);
    }

    @Override
    public BooleanResult deleteByMap(Map<String, Object> columnMap) {
        boolean b = this.getBaseDao().deleteByMap(columnMap) > 0;
        return new BooleanResult(b);
    }

    @Override
    public BooleanResult deleteByIds(Collection<? extends Serializable> idList) {
        boolean b = this.getBaseDao().deleteBatchIds(idList) > 0;
        return new BooleanResult(b);
    }

    @Override
    public BooleanResult updateById(E entity) {
        boolean b = this.getBaseDao().updateById(entity) > 0;
        return new BooleanResult(b);
    }

    @Override
    public DetailResult<E> getById(Serializable id) {
        Entity e = (Entity)this.getBaseDao().selectById(id);
        return new DetailResult<Entity>(e);
    }

    @Override
    public ListResult<E> getByMap(Map<String, Object> columnMap) {
        List es = this.getBaseDao().selectByMap(columnMap);
        return new ListResult(es);
    }

    @Override
    public DetailResult<E> selectOne(E condition) {
        Entity e = (Entity)this.getBaseDao().selectOne((Wrapper)new QueryWrapper(condition));
        return new DetailResult<Entity>(e);
    }

    @Override
    public ListResult<E> selectList(E condition) {
        List es = this.getBaseDao().selectList((Wrapper)Wrappers.query(condition));
        return new ListResult(es);
    }

    @Override
    public ListResult<E> selectByIds(Collection<? extends Serializable> idList) {
        List es = this.getBaseDao().selectBatchIds(idList);
        return new ListResult(es);
    }

    @Override
    public PageResult<E> selectByPage(IPage<E> page) {
        return this.selectByPage(page, null);
    }

    @Override
    public PageResult<E> selectByPage(IPage<E> page, E condition) {
        IPage eiPage = this.getBaseDao().selectPage(page, (Wrapper)new QueryWrapper(condition));
        return new PageResult(eiPage);
    }

    protected D getBaseDao() {
        return this.baseDao;
    }

    @Autowired
    protected void setBaseDao(D baseDao) {
        this.baseDao = baseDao;
    }
}

