/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.mvc;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.Result;
import com.iteaj.util.module.mvc.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class AbstractMvcController<R extends Result>
implements EnvironmentAware {
    private Environment environment;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected String msgForSuccess() {
        return "OK";
    }

    protected String msgForFail() {
        return "\u62b1\u6b49! \u64cd\u4f5c\u5931\u8d25";
    }

    protected boolean isProfile(String profile) {
        if (CommonUtils.isBlank(profile)) {
            return false;
        }
        return this.environment.acceptsProfiles(new String[]{profile});
    }

    protected R fail() {
        return this.fail(this.msgForFail());
    }

    protected R success() {
        return this.success(this.msgForSuccess());
    }

    protected abstract R fail(String var1);

    protected abstract R success(String var1);

    @ResponseBody
    @ExceptionHandler(value={Throwable.class})
    protected R throwableHandle(Throwable e) {
        this.logger.error("\u7c7b\u522b\uff1a\u5f02\u5e38\u5904\u7406 - \u52a8\u4f5c\uff1a\u5168\u5c40\u5f02\u5e38 - \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
        if (this.isProfile("prod")) {
            return this.fail(this.msgForFail());
        }
        if (this.isProfile("dev")) {
            return this.fail(e.getMessage());
        }
        return this.fail(this.msgForFail());
    }

    @ResponseBody
    @ExceptionHandler(value={ServiceException.class})
    protected R serviceHandle(ServiceException e) {
        this.logger.error("\u7c7b\u522b\uff1a\u5f02\u5e38\u5904\u7406 - \u52a8\u4f5c\uff1a\u4e1a\u52a1\u5f02\u5e38 - \u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
        String failMsg = CommonUtils.isBlank(e.getServiceMessage()) ? e.getMessage() : e.getServiceMessage();
        return this.fail(failMsg);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

