/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonArray;
import com.iteaj.util.module.json.jackson.Jackson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

public class JacksonArray
implements JsonArray {
    private ArrayNode nodes;
    private ObjectMapper mapper;

    public JacksonArray(ArrayNode nodes, ObjectMapper mapper) {
        this.nodes = nodes;
        this.mapper = mapper;
        AssertUtils.isTrue(null != mapper, "\u521b\u5efaJacksonArray\u5931\u8d25, \u7f3a\u5931\u53c2\u6570\uff1aObjectMapper\u5bf9\u8c61", UtilsType.JSON);
        AssertUtils.isTrue(null != nodes, "\u521b\u5efaJacksonArray\u5931\u8d25, \u7f3a\u5931\u53c2\u6570\uff1aArrayNode\u5bf9\u8c61", UtilsType.JSON);
    }

    public ArrayNode original() {
        return this.nodes;
    }

    @Override
    public int size() {
        return this.original().size();
    }

    @Override
    public Short getShort(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : Short.valueOf(node.shortValue());
    }

    @Override
    public Integer getInt(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : Integer.valueOf(node.intValue());
    }

    @Override
    public Float getFloat(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(null == node, index, isThrow);
        return node == null ? null : Float.valueOf(node.floatValue());
    }

    @Override
    public Double getDouble(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(null == node, index, isThrow);
        return node == null ? null : Double.valueOf(node.doubleValue());
    }

    @Override
    public Long getLong(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : Long.valueOf(node.longValue());
    }

    @Override
    public BigDecimal getBigDecimal(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : new BigDecimal(node.bigIntegerValue());
    }

    @Override
    public Boolean getBoolean(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : Boolean.valueOf(node.asBoolean());
    }

    @Override
    public String getString(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(node == null, index, isThrow);
        return node == null ? null : node.asText(null);
    }

    @Override
    public Json getJson(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(!node.isObject(), index, isThrow);
        return node == null ? null : new Jackson((ContainerNode)((ObjectNode)node), this.mapper);
    }

    @Override
    public JsonArray getJsonArray(int index, boolean ... isThrow) {
        JsonNode node = this.original().get(index);
        this.isThrow(!node.isArray(), index, isThrow);
        return node == null ? null : new JacksonArray((ArrayNode)node, this.mapper);
    }

    @Override
    public <T> ArrayList<T> toList(Class<T> clazz) {
        CollectionType type = this.mapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
        return (ArrayList)this.mapper.convertValue((Object)this.original(), (JavaType)type);
    }

    @Override
    public <E> Iterator<E> iterator() {
        Iterator iterator = this.original().iterator();
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(item -> {
            try {
                if (item instanceof NumericNode) {
                    list.add(this.mapper.treeToValue((TreeNode)item, Number.class));
                } else if (item instanceof BooleanNode) {
                    list.add(this.mapper.treeToValue((TreeNode)item, Boolean.class));
                } else if (item instanceof ObjectNode) {
                    list.add(new Jackson((ContainerNode)((ObjectNode)item), this.mapper));
                } else if (item instanceof ArrayNode) {
                    list.add(new JacksonArray((ArrayNode)item, this.mapper));
                } else {
                    list.add(item.asText());
                }
            }
            catch (JsonProcessingException e) {
                throw new UtilsException(e.getMessage(), UtilsType.JSON);
            }
        });
        return list.iterator();
    }

    @Override
    public <T> T toArray(Class<T> arrayType) {
        try {
            if (!arrayType.isArray()) {
                throw new UtilsException("\u6570\u7ec4\u7c7b\u578b\u9519\u8bef e.g Integer[].class", UtilsType.JSON);
            }
            return (T)this.mapper.treeToValue((TreeNode)this.original(), arrayType);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException("\u53cd\u5e8f\u5217\u5316JsonArray\u5230Java\u5bf9\u8c61\u5931\u8d25", e, UtilsType.JSON);
        }
    }

    @Override
    public String toJsonString() {
        try {
            return this.mapper.writeValueAsString((Object)this.original());
        }
        catch (JsonProcessingException e) {
            throw new UtilsException(e.getMessage(), UtilsType.JSON);
        }
    }
}

