/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonAdapter;
import com.iteaj.util.module.json.jackson.Jackson;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JacksonAdapter
implements JsonAdapter<ObjectMapper> {
    protected ObjectMapper objectMapper;

    public JacksonAdapter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        AssertUtils.isTrue(objectMapper != null, "\u5b9e\u4f8b\u5316JacksonAdapter\u5fc5\u987b\u4f20\u5165ObjectMapper\u5bf9\u8c61\u4f5c\u4e3a\u6784\u9020\u53c2\u6570", UtilsType.JSON);
    }

    @Override
    public String toJson(Object obj) {
        try {
            if (null == obj) {
                return null;
            }
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.JSON);
        }
    }

    @Override
    public String toJson(Object obj, SimpleDateFormat format) {
        try {
            if (null == obj) {
                return null;
            }
            if (null == format) {
                throw new UtilsException("\u5199\u51faJson\u5b57\u7b26\u4e32\u65f6\u5fc5\u987b\u6307\u5b9a\u65f6\u95f4\u683c\u5f0f\u5bf9\u8c61\uff1aSimpleDateFormat", UtilsType.JSON);
            }
            return this.objectMapper.writer((DateFormat)format).writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.JSON);
        }
    }

    @Override
    public <T> T toBean(String json, Class<T> clazz) {
        try {
            if (null == json || null == clazz) {
                return null;
            }
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.JSON);
        }
    }

    @Override
    public <T> List<T> toList(String json, Class<T> elementType) {
        try {
            if (null == json || null == elementType) {
                return null;
            }
            CollectionType type = this.getTypeFactory(this.objectMapper).constructCollectionType(ArrayList.class, elementType);
            return (List)this.objectMapper.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.JSON);
        }
    }

    @Override
    public <T> T toArray(String json, Class<T> arrayType) {
        if (!arrayType.isArray()) {
            throw new UtilsException("\u53cd\u5e8f\u5217\u5316JsonArray, \u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u7ec4\u7c7b\u578beg\uff1aInteger[].class", UtilsType.JSON);
        }
        return this.toBean(json, arrayType);
    }

    @Override
    public <K, V> Map<K, V> toMap(String json, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        try {
            if (null == json) {
                return null;
            }
            if (null == mapType || null == keyType || valueType == null) {
                throw new UtilsException("Json\u89e3\u6790\u5230Map \u5fc5\u987b\u6307\u5b9aMap\u7684Key-Value\u7c7b\u578b", UtilsType.JSON);
            }
            MapType mapType1 = this.getTypeFactory(this.objectMapper).constructMapType(mapType, keyType, valueType);
            return (Map)this.objectMapper.readValue(json, (JavaType)mapType1);
        }
        catch (IOException e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.JSON);
        }
    }

    @Override
    public ObjectMapper getOriginal() {
        return this.objectMapper;
    }

    @Override
    public Json builder() {
        return new Jackson((ContainerNode)this.getNodeFactory().objectNode(), this.objectMapper);
    }

    @Override
    public Json builder(String json) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(json);
            if (jsonNode.isContainerNode()) {
                return new Jackson((ContainerNode)jsonNode, this.objectMapper);
            }
            throw new UtilsException("\u9519\u8bef\u7684json\u5b57\u7b26\u4e32\uff1a" + json, UtilsType.JSON);
        }
        catch (IOException e) {
            throw new UtilsException("\u9519\u8bef\u7684json\u5b57\u7b26\u4e32\uff1a" + json, UtilsType.JSON);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected JsonNodeFactory getNodeFactory() {
        return this.getObjectMapper().getNodeFactory();
    }

    protected TypeFactory getTypeFactory(ObjectMapper objectMapper) {
        return objectMapper.getTypeFactory();
    }
}

