/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.AbstractJson;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonArray;
import com.iteaj.util.module.json.Type;
import com.iteaj.util.module.json.jackson.JacksonArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Jackson
extends AbstractJson<JsonNode> {
    private JsonNode node;
    private ObjectMapper mapper;

    public Jackson(String json, ObjectMapper mapper) {
        try {
            this.mapper = mapper;
            AssertUtils.isTrue(mapper != null, "\u5b9e\u4f8b\u5316Jackson\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165ObjectMapper\u5bf9\u8c61\u4f5c\u4e3a\u6784\u9020\u53c2\u6570", UtilsType.JSON);
            this.node = mapper.readTree(json);
            AssertUtils.isTrue(this.node.isContainerNode(), "\u9519\u8bef\u7684json\u5b57\u7b26\u4e32\uff1a" + json, UtilsType.JSON);
        }
        catch (IOException e) {
            throw new UtilsException("\u6784\u5efaJackson\u5931\u8d25, \u9519\u8bef\u7684json\u5b57\u7b26\u4e32\uff1a" + json, UtilsType.JSON);
        }
    }

    public Jackson(ContainerNode node, ObjectMapper mapper) {
        this.node = node;
        this.mapper = mapper;
        AssertUtils.isTrue(mapper != null, "\u5b9e\u4f8b\u5316Jackson\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165ObjectMapper\u5bf9\u8c61\u4f5c\u4e3a\u6784\u9020\u53c2\u6570", UtilsType.JSON);
    }

    @Override
    public Type getType() {
        return Type.Jackson;
    }

    @Override
    public JsonNode original() {
        return this.node;
    }

    @Override
    public int size() {
        return this.original().size();
    }

    @Override
    public Json add(String name, Object val) {
        if (CommonUtils.isBlank(name)) {
            throw new UtilsException("\u65b0\u589eJson\u8282\u70b9\u65f6\u5fc5\u987b\u6307\u5b9a\u8282\u70b9\u540d", UtilsType.JSON);
        }
        if (this.original() instanceof ObjectNode) {
            if (val instanceof Jackson) {
                ((ObjectNode)this.original()).set(name, ((Jackson)val).original());
            } else if (val instanceof JacksonArray) {
                ((ObjectNode)this.original()).set(name, (JsonNode)((JacksonArray)val).original());
            } else {
                ((ObjectNode)this.original()).putPOJO(name, val);
            }
        } else {
            throw new UtilsException("\u53ea\u5141\u8bb8ObjectNode\u5b9e\u4f8b\u65b0\u589e\u8282\u70b9", UtilsType.JSON);
        }
        return this;
    }

    @Override
    public Json remove(String name) {
        if (this.original() instanceof ObjectNode) {
            ((ObjectNode)this.original()).remove(name);
        } else {
            this.logger.warn("\u7c7b\u522b\uff1aJson - \u52a8\u4f5c\uff1a\u79fb\u9664Json\u8282\u70b9 - \u4fe1\u606f\uff1a\u53ea\u5141\u8bb8ObjectNode\u5b9e\u4f8b\u8fdb\u884c\u8282\u70b9\u79fb\u9664");
        }
        return this;
    }

    @Override
    public boolean isExist(String name) {
        JsonNode jsonNode = this.original();
        return jsonNode != null && jsonNode.has(name);
    }

    @Override
    public boolean isNull(String name) {
        JsonNode jsonNode = this.original().get(name);
        return this.isExist(name) || jsonNode.isNull();
    }

    @Override
    public String toJsonString() {
        try {
            return this.mapper.writeValueAsString((Object)this.original());
        }
        catch (JsonProcessingException e) {
            throw new UtilsException("\u5199\u51faJson\u5b57\u7b26\u4e32\u5931\u8d25", e, UtilsType.JSON);
        }
    }

    @Override
    public Boolean getBoolean(String name, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? Boolean.valueOf(node.asBoolean()) : null;
    }

    @Override
    public Short getShort(String name, Short defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.shortValue() : defaultValue.shortValue();
    }

    @Override
    public Integer getInt(String name, Integer defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.asInt() : defaultValue.intValue();
    }

    @Override
    public Long getLong(String name, Long defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.asLong() : defaultValue.longValue();
    }

    @Override
    public Float getFloat(String name, Float defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return Float.valueOf(node != null ? node.floatValue() : defaultValue.floatValue());
    }

    @Override
    public Double getDouble(String name, Double defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.asDouble() : defaultValue.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.decimalValue() : defaultValue;
    }

    @Override
    public Date getDate(String name, Date defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        try {
            return node != null ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(node.asText()) : defaultValue;
        }
        catch (ParseException e) {
            throw new UtilsException(e.getMessage(), UtilsType.JSON);
        }
    }

    @Override
    public String getString(String name, String defaultValue, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? node.asText() : defaultValue;
    }

    @Override
    public <R> R toBean(Class<R> clazz) {
        try {
            return (R)this.mapper.treeToValue((TreeNode)this.original(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff1a" + this.original().toString() + " --> " + clazz.getName(), e, UtilsType.JSON);
        }
    }

    @Override
    public JsonArray toJsonArray() {
        return new JacksonArray(this.mapper.getNodeFactory().arrayNode(), this.mapper);
    }

    @Override
    public JsonArray getJsonArray(String name, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? new JacksonArray((ArrayNode)node, this.mapper) : new JacksonArray(this.mapper.getNodeFactory().arrayNode(), this.mapper);
    }

    @Override
    public Json getJson(String name, boolean ... isThrow) {
        JsonNode node = this.original().get(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : node, name, isThrow);
        return node != null ? new Jackson((ContainerNode)((ObjectNode)node), this.mapper) : new Jackson((ContainerNode)this.mapper.getNodeFactory().objectNode(), this.mapper);
    }

    @Override
    public <T> T getPath(String path, boolean ... isThrow) {
        JsonNode node = this.original().at(path);
        this.isThrow(node.isMissingNode() ? NOT_EXISTS : node, path, isThrow);
        if (node.isMissingNode()) {
            return null;
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isNumber()) {
            return (T)node.numberValue();
        }
        if (node.isBoolean()) {
            return (T)Boolean.valueOf(node.booleanValue());
        }
        if (node.isContainerNode()) {
            return (T)new Jackson((ContainerNode)node, this.mapper);
        }
        return (T)node.asText();
    }
}

