/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.AbstractJson;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonArray;
import com.iteaj.util.module.json.Type;
import com.iteaj.util.module.json.fastjson.FastJsonArray;
import java.beans.Transient;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

public class Fastjson
extends AbstractJson<JSON> {
    private JSON json;

    public Fastjson(JSON json) {
        this.json = json;
    }

    @Override
    @Transient
    public Type getType() {
        return Type.FastJson;
    }

    @Override
    public JSON original() {
        return this.json;
    }

    @Override
    public int size() {
        return this.getObject().size();
    }

    @Override
    public Json add(String name, Object val) {
        this.getObject().put(name, val);
        return this;
    }

    @Override
    public Json remove(String name) {
        this.getObject().remove((Object)name);
        return this;
    }

    @Override
    public boolean isExist(String name) {
        return this.getObject().containsKey((Object)name);
    }

    @Override
    public boolean isNull(String name) {
        Object o = this.getObject().get((Object)name);
        return o == null;
    }

    @Transient
    protected JSONObject getObject() {
        if (this.json instanceof JSONObject) {
            return (JSONObject)this.json;
        }
        throw new UtilsException("\u53ea\u6709JSONObject\u5bf9\u8c61\u624d\u5141\u8bb8\u7684\u64cd\u4f5c", UtilsType.JSON);
    }

    @Override
    public String toJsonString() {
        return this.original().toJSONString();
    }

    @Override
    public Boolean getBoolean(String name, boolean ... isThrow) {
        Boolean o = this.getObject().getBoolean(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Short getShort(String name, Short defaultValue, boolean ... isThrow) {
        Short o = this.getObject().getShort(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public Integer getInt(String name, Integer defaultValue, boolean ... isThrow) {
        Integer o = this.getObject().getInteger(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public Long getLong(String name, Long defaultValue, boolean ... isThrow) {
        Long o = this.getObject().getLong(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public Float getFloat(String name, Float defaultValue, boolean ... isThrow) {
        Object o = this.getObject().get((Object)name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? (Float)o : defaultValue;
    }

    @Override
    public Double getDouble(String name, Double defaultValue, boolean ... isThrow) {
        Double o = this.getObject().getDouble(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue, boolean ... isThrow) {
        BigDecimal o = this.getObject().getBigDecimal(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public Date getDate(String name, Date defaultValue, boolean ... isThrow) {
        Date o = this.getObject().getDate(name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o : defaultValue;
    }

    @Override
    public String getString(String name, String defaultValue, boolean ... isThrow) {
        Object o = this.getObject().get((Object)name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? o.toString() : defaultValue;
    }

    @Override
    public <R> R toBean(Class<R> clazz) {
        return (R)this.original().toJavaObject(clazz);
    }

    @Override
    public JsonArray toJsonArray() {
        return this.original() instanceof JSONArray ? new FastJsonArray((JSONArray)this.original()) : null;
    }

    @Override
    public JsonArray getJsonArray(String name, boolean ... isThrow) {
        Object o = this.getObject().get((Object)name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? new FastJsonArray((JSONArray)o) : new FastJsonArray(new JSONArray());
    }

    @Override
    public Json getJson(String name, boolean ... isThrow) {
        Object o = this.getObject().get((Object)name);
        this.isThrow(!this.isExist(name) ? NOT_EXISTS : o, name, isThrow);
        return o != null ? new Fastjson((JSON)((JSONObject)o)) : new Fastjson((JSON)new JSONObject());
    }

    @Override
    public <R> R getPath(String path, boolean ... isThrow) {
        if (CommonUtils.isBlank(path)) {
            return null;
        }
        Object[] split = path.split("/", -1);
        if (!CommonUtils.isNotEmpty(split)) {
            throw new UtilsException("\u9519\u8bef\u7684Json\u8def\u5f84, \u4f8b\u5982\uff1a/store/book/title", UtilsType.JSON);
        }
        String jsonPath = Arrays.stream(split).filter(item -> !CommonUtils.isBlank(item)).collect(Collectors.joining(".", "$.", ""));
        Object eval = JSONPath.eval((Object)this.original(), (String)jsonPath);
        this.isThrow(!JSONPath.contains((Object)this.original(), (String)jsonPath) ? NOT_EXISTS : eval, path, isThrow);
        if (eval instanceof JSONArray) {
            return (R)new FastJsonArray((JSONArray)eval);
        }
        if (eval instanceof JSONObject) {
            return (R)new Fastjson((JSON)eval);
        }
        return (R)eval;
    }
}

