/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonArray;
import com.iteaj.util.module.json.fastjson.Fastjson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

public class FastJsonArray
implements JsonArray {
    private JSONArray array;

    public FastJsonArray(JSONArray array) {
        this.array = array;
        AssertUtils.isTrue(array != null, "\u672a\u4f20\u5165\u7c7b\u578b\u4e3aJSONArray\u7684\u6784\u9020\u53c2\u6570", UtilsType.JSON);
    }

    public JSONArray original() {
        return this.array;
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public Short getShort(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Short o = this.original().getShort(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Integer getInt(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Integer o = this.original().getInteger(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Float getFloat(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Float o = this.original().getFloat(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Double getDouble(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Double o = this.original().getDouble(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Long getLong(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Long o = this.original().getLong(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public BigDecimal getBigDecimal(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        BigDecimal o = this.original().getBigDecimal(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o : null;
    }

    @Override
    public Boolean getBoolean(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Boolean o = this.original().getBoolean(0);
        this.isThrow(o == null, index, isThrow);
        return o == null ? o : null;
    }

    @Override
    public String getString(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        Object o = this.original().get(index);
        this.isThrow(o == null, index, isThrow);
        return o != null ? o.toString() : null;
    }

    @Override
    public Json getJson(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        JSONObject o = this.original().getJSONObject(index);
        this.isThrow(o == null || !(o instanceof JSONObject), index, isThrow);
        return new Fastjson((JSON)o);
    }

    @Override
    public JsonArray getJsonArray(int index, boolean ... isThrow) {
        if (this.original().isEmpty()) {
            return null;
        }
        JSONArray o = this.original().getJSONArray(index);
        this.isThrow(!(o instanceof JSONArray), index, isThrow);
        return o == null ? null : (o instanceof JSONArray ? new FastJsonArray(o) : null);
    }

    @Override
    public <T> ArrayList<T> toList(Class<T> eleType) {
        return (ArrayList)this.original().toJavaList(eleType);
    }

    @Override
    public <E> Iterator<E> iterator() {
        Iterator iterator = this.original().iterator();
        ArrayList e = new ArrayList();
        if (null != iterator) {
            iterator.forEachRemaining(item -> {
                if (item instanceof JSONObject) {
                    e.add(new Fastjson((JSON)item));
                } else if (item instanceof JSONArray) {
                    e.add(new FastJsonArray((JSONArray)item));
                } else {
                    e.add(item);
                }
            });
        }
        return e.iterator();
    }

    @Override
    public <T> T toArray(Class<T> arrayType) {
        if (!arrayType.isArray()) {
            throw new UtilsException("\u53cd\u5e8f\u5217\u5316JsonArray, \u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u7ec4\u7c7b\u578beg\uff1aInteger[].class", UtilsType.JSON);
        }
        return (T)JSONObject.toJavaObject((JSON)this.original(), arrayType);
    }

    @Override
    public String toJsonString() {
        return this.original().toJSONString();
    }
}

