/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.json.JsonAdapter;
import com.iteaj.util.module.json.fastjson.Fastjson;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FastJsonAdapter
implements JsonAdapter<JSON> {
    @Override
    public String toJson(Object obj) {
        if (null == obj) {
            return null;
        }
        return JSON.toJSONString((Object)obj);
    }

    @Override
    public String toJson(Object obj, SimpleDateFormat format) {
        if (null == obj) {
            return null;
        }
        if (null == format) {
            return JSON.toJSONString((Object)obj);
        }
        return JSON.toJSONStringWithDateFormat((Object)obj, (String)format.toPattern(), (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    public <T> T toBean(String json, Class<T> clazz) {
        if (null == json || clazz == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, clazz);
    }

    @Override
    public <T> List<T> toList(String json, Class<T> elementType) {
        if (null == json || elementType == null) {
            return null;
        }
        return JSONObject.parseArray((String)json, elementType);
    }

    @Override
    public <T> T toArray(String json, Class<T> arrayType) {
        if (!arrayType.isArray()) {
            throw new UtilsException("\u53cd\u5e8f\u5217\u5316JsonArray, \u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u7ec4\u7c7b\u578beg\uff1aInteger[].class", UtilsType.JSON);
        }
        return (T)JSONObject.parseObject((String)json, arrayType);
    }

    @Override
    public <K, V> Map<K, V> toMap(String json, Class<? extends Map> mapType, Class<K> keyType, Class<V> valueType) {
        if (null == json) {
            return null;
        }
        if (null == mapType || null == keyType || valueType == null) {
            throw new UtilsException("Json\u89e3\u6790\u5230Map \u5fc5\u987b\u6307\u5b9aMap\u7684Key-Value\u7c7b\u578b", UtilsType.JSON);
        }
        if (mapType == HashMap.class) {
            return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<HashMap<K, V>>(){}, (Feature[])new Feature[0]);
        }
        if (mapType == TreeMap.class) {
            return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<TreeMap<K, V>>(){}, (Feature[])new Feature[0]);
        }
        if (mapType == LinkedHashMap.class) {
            return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<LinkedHashMap<K, V>>(){}, (Feature[])new Feature[0]);
        }
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<HashMap<K, V>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public JSON getOriginal() {
        return new JSONObject();
    }

    @Override
    public Json builder() {
        return new Fastjson((JSON)new JSONObject());
    }

    @Override
    public Json builder(String json) {
        Object parse = JSONObject.parse((String)json);
        if (parse instanceof JSON) {
            return new Fastjson((JSON)parse);
        }
        throw new UtilsException("\u9519\u8bef\u7684Json\u683c\u5f0f\uff1a" + json, UtilsType.JSON);
    }
}

