/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.json;

import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.json.Json;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJson<T>
implements Json<T> {
    protected static final String DEFAULT_PATTERN = "yyyy-MM-dd hh:mm:ss";
    protected static NotExists NOT_EXISTS = NotExists.getInstance();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Short getShort(String name, boolean ... isThrow) {
        return this.getShort(name, null, isThrow);
    }

    @Override
    public Integer getInt(String name, boolean ... isThrow) {
        return this.getInt(name, null, isThrow);
    }

    @Override
    public Long getLong(String name, boolean ... isThrow) {
        return this.getLong(name, null, isThrow);
    }

    @Override
    public Float getFloat(String name, boolean ... isThrow) {
        return this.getFloat(name, null, isThrow);
    }

    @Override
    public Double getDouble(String name, boolean ... isThrow) {
        return this.getDouble(name, 0.0, isThrow);
    }

    @Override
    public BigDecimal getBigDecimal(String name, boolean ... isThrow) {
        return this.getBigDecimal(name, null, isThrow);
    }

    @Override
    public Date getDate(String name, boolean ... isThrow) {
        return this.getDate(name, null, isThrow);
    }

    @Override
    public String getDateString(String name, boolean ... isThrow) {
        return this.getDateString(name, DEFAULT_PATTERN, null, isThrow);
    }

    @Override
    public String getDateString(String name, String pattern, Date defaultValue, boolean ... isThrow) {
        Date date = this.getDate(name, defaultValue, isThrow);
        return null == date ? null : new SimpleDateFormat(pattern).format(date);
    }

    @Override
    public String getString(String name, boolean ... isThrow) {
        return this.getString(name, null, isThrow);
    }

    protected void isThrow(Object val, String name, boolean ... isThrow) {
        isThrow = new boolean[]{isThrow.length == 1 ? isThrow[0] : true, isThrow.length == 2 ? isThrow[1] : false};
        if (val instanceof NotExists) {
            this.logger.warn("\u8282\u70b9\"{}\"\u4e0d\u5b58\u5728 - \u5728\u5f53\u524d\u503c\u91cc\u9762\uff1a{}", (Object)name, (Object)this.toJsonString());
            if (isThrow[0]) {
                throw new UtilsException("\u8282\u70b9\"" + name + "\"\u4e0d\u5b58\u5728 - \u5728\u5f53\u524d\u503c\u91cc\u9762\uff1a" + this.toJsonString(), UtilsType.JSON);
            }
        }
        if (val == null && isThrow[1]) {
            throw new UtilsException("Json\u8282\u70b9\u7684\u503c\u4e3aNull\uff1a" + name, UtilsType.JSON);
        }
    }

    public String toString() {
        return this.toJsonString();
    }

    protected static class NotExists {
        private static NotExists notExists = new NotExists();

        protected NotExists() {
        }

        public static NotExists getInstance() {
            return notExists;
        }
    }
}

