/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.build;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.Const;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.AbstractBuilder;
import com.iteaj.util.module.http.ContentType;
import java.io.UnsupportedEncodingException;

public class StreamBuilder
extends AbstractBuilder<StreamBuilder> {
    private byte[] stream;

    private StreamBuilder(String url, String charset) {
        super(url, charset);
    }

    public static StreamBuilder build(String url) {
        return StreamBuilder.build(url, Const.UTF_8.name());
    }

    public static StreamBuilder build(String url, String charset) {
        if (!CommonUtils.isNotBlank(url)) {
            throw new UtilsException("\u672a\u6307\u5b9a\u8bf7\u6c42URL", UtilsType.HTTP);
        }
        if (CommonUtils.isBlank(charset)) {
            charset = Const.UTF_8.name();
        }
        return new StreamBuilder(url, charset);
    }

    @Override
    public StreamBuilder addBody(String name, String value) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u952e\u503c\u5bf9\u7684\u53c2\u6570");
    }

    public StreamBuilder setForPlain(String content) {
        if (CommonUtils.isBlank(content)) {
            throw new UtilsException("\u672a\u8bbe\u7f6e\u8bf7\u6c42\u5185\u5bb9", UtilsType.HTTP);
        }
        try {
            this.stream = content.getBytes(this.getCharset());
            this.setType(ContentType.Plain);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsException(e.getMessage(), UtilsType.HTTP);
        }
        return this;
    }

    public StreamBuilder setForJson(String content) {
        if (CommonUtils.isBlank(content)) {
            throw new UtilsException("\u672a\u8bbe\u7f6e\u8bf7\u6c42\u5185\u5bb9", UtilsType.HTTP);
        }
        try {
            this.stream = content.getBytes(this.getCharset());
            this.setType(ContentType.Json);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsException(e.getMessage(), UtilsType.HTTP);
        }
        return this;
    }

    public StreamBuilder setForHtml(String content) {
        if (CommonUtils.isBlank(content)) {
            throw new UtilsException("\u672a\u8bbe\u7f6e\u8bf7\u6c42\u5185\u5bb9", UtilsType.HTTP);
        }
        try {
            this.stream = content.getBytes(this.getCharset());
            this.setType(ContentType.Html);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsException(e.getMessage(), UtilsType.HTTP);
        }
        return this;
    }

    public StreamBuilder setForXml(String content) {
        if (CommonUtils.isBlank(content)) {
            throw new UtilsException("\u672a\u8bbe\u7f6e\u8bf7\u6c42\u5185\u5bb9", UtilsType.HTTP);
        }
        try {
            this.stream = content.getBytes(this.getCharset());
            this.setType(ContentType.Xml);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsException(e.getMessage(), UtilsType.HTTP);
        }
        return this;
    }

    public StreamBuilder setForStream(byte[] bytes) {
        if (!CommonUtils.isNotEmpty(bytes)) {
            throw new UtilsException("\u672a\u8bbe\u7f6e\u8bf7\u6c42\u5185\u5bb9", UtilsType.HTTP);
        }
        this.stream = bytes;
        this.setType(ContentType.OctetStream);
        return this;
    }

    public byte[] getStream() {
        return this.stream;
    }

    public String toString() {
        return new String(this.stream);
    }
}

