/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.build;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.Const;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.AbstractBuilder;
import com.iteaj.util.module.http.ContentType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;

public class MultipartBuilder
extends AbstractBuilder<MultipartBuilder> {
    private String boundary;

    private MultipartBuilder(String url, String charset, ContentType type) {
        super(url, charset, type);
        this.bodys = new ArrayList();
        this.boundary = UUID.randomUUID().toString();
    }

    public static MultipartBuilder build(String url) throws UtilsException {
        return MultipartBuilder.build(url, Const.UTF_8.name());
    }

    public static MultipartBuilder build(String url, String charset) throws UtilsException {
        if (!CommonUtils.isNotBlank(url)) {
            throw new UtilsException("\u672a\u6307\u5b9a\u8bf7\u6c42URL", UtilsType.HTTP);
        }
        return new MultipartBuilder(url, charset, ContentType.Multipart);
    }

    public MultipartBuilder addBody(String name, String value, ContentType type) {
        this.bodys.add((AbstractBuilder)this.new AbstractBuilder.BodyParam(name, value, this.getCharset(), type));
        return this;
    }

    public MultipartBuilder addBody(String name, byte[] bytes, String fileName) {
        this.bodys.add((AbstractBuilder)this.new AbstractBuilder.BodyParam(name, bytes, fileName, ContentType.OctetStream));
        return this;
    }

    public MultipartBuilder addBody(String name, File file) {
        try {
            if (!CommonUtils.isNotBlank(name) || null == file) {
                throw new UtilsException("\u589e\u52a0http\u5b9e\u4f53\u7684\u6240\u9700\u53c2\u6570\u9519\u8bef", UtilsType.HTTP);
            }
            byte[] read = CommonUtils.read(file);
            String fileName = CommonUtils.fileName(file.getPath());
            AbstractBuilder.BodyParam bodyParam = (AbstractBuilder)this.new AbstractBuilder.BodyParam(name, read, fileName, ContentType.OctetStream);
            this.type = ContentType.Multipart;
            this.bodys.add(bodyParam);
        }
        catch (IOException e) {
            throw new UtilsException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e, UtilsType.HTTP);
        }
        return this;
    }

    public String getBoundary() {
        return this.boundary;
    }
}

