/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.adapter;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdkHttpResponse
implements HttpResponse {
    private int statusCode;
    private byte[] content;
    private String message;
    private HttpURLConnection connection;
    private Map<String, String> headers;
    private static Map<String, String> EMPTY = new HashMap<String, String>(0);

    public JdkHttpResponse(int statusCode, byte[] content, HttpURLConnection connection) {
        try {
            this.content = content;
            this.statusCode = statusCode;
            this.connection = connection;
            this.headers = this.getHeaderFields(connection);
            this.message = connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new UtilsException("\u89e3\u6790\u54cd\u5e94\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    private Map<String, String> getHeaderFields(HttpURLConnection connection) {
        Map<String, List<String>> fields = connection.getHeaderFields();
        if (!CommonUtils.isNotEmpty(fields)) {
            return EMPTY;
        }
        this.headers = new HashMap<String, String>(fields.size());
        for (String name : fields.keySet()) {
            List<String> values = fields.get(name);
            this.headers.put(name, CommonUtils.concat(values, "separator"));
        }
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public boolean isOk() {
        return this.getStatus() == 200;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("{0} {1}", this.getStatus(), this.message);
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String getContent(String charset) {
        try {
            if (CommonUtils.isNotEmpty(this.content)) {
                return new String(this.content, charset);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilsException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\uff1a" + charset, e, UtilsType.HTTP);
        }
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public String getContentEncoding() {
        return this.headers.get("Content-Encoding");
    }

    @Override
    public void close() {
        if (null != this.connection) {
            this.connection.disconnect();
        }
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

