/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.adapter;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.AbstractBuilder;
import com.iteaj.util.module.http.HttpAdapter;
import com.iteaj.util.module.http.HttpHeader;
import com.iteaj.util.module.http.HttpRequestConfig;
import com.iteaj.util.module.http.SSLContextManager;
import com.iteaj.util.module.http.adapter.JdkHttpResponse;
import com.iteaj.util.module.http.build.MultipartBuilder;
import com.iteaj.util.module.http.build.StreamBuilder;
import com.iteaj.util.module.http.build.UrlBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpAdapter
implements HttpAdapter<JdkHttpResponse> {
    private static String PREFIX = "--";
    private static String ENTER = "\r\n";
    private static byte[] ENTER_BYTES = ENTER.getBytes();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public JdkHttpResponse get(UrlBuilder builder) throws UtilsException {
        return this.getJdkHttpResponse(builder, "GET");
    }

    @Override
    public JdkHttpResponse post(UrlBuilder builder) throws UtilsException {
        return this.getJdkHttpResponse(builder, "POST");
    }

    @Override
    public JdkHttpResponse post(StreamBuilder builder) throws UtilsException {
        return this.getJdkHttpResponse(builder, "POST");
    }

    @Override
    public JdkHttpResponse post(MultipartBuilder builder) throws UtilsException {
        return this.getJdkHttpResponse(builder, "POST");
    }

    private JdkHttpResponse getJdkHttpResponse(AbstractBuilder builder, String method) {
        if (null == builder) {
            throw new UtilsException("\u672a\u6307\u5b9a\u8bf7\u6c42\u7684\u914d\u7f6e\u548c\u53c2\u6570\u4fe1\u606f\uff1a" + AbstractBuilder.class.getSimpleName(), UtilsType.HTTP);
        }
        HttpURLConnection connection = Objects.equals("GET", method) ? this.getConnection(builder, builder.parseUrl(), method) : this.getConnection(builder, builder.getUrl(), method);
        this.setHeaders(connection, builder);
        return this.doConnect(connection, builder);
    }

    protected HttpURLConnection getConnection(AbstractBuilder builder, String urlStr, String method) {
        try {
            HttpURLConnection httpConnection;
            HttpRequestConfig config = builder.getRequestConfig();
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            if ("http".equals(protocol)) {
                httpConnection = (HttpURLConnection)url.openConnection();
            } else if ("https".equals(protocol)) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
                httpsConnection.setRequestMethod(method);
                SSLContextManager sslManager = UtilsFactory.getDefaultSslManager();
                httpsConnection.setSSLSocketFactory(sslManager.getSslContext().getSocketFactory());
                httpConnection = httpsConnection;
            } else {
                throw new UtilsException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\uff1a" + protocol, UtilsType.HTTP);
            }
            if ("POST".equalsIgnoreCase(method)) {
                httpConnection.setDoOutput(true);
            }
            httpConnection.setRequestMethod(method);
            httpConnection.setUseCaches(config.isUseCaches());
            httpConnection.setReadTimeout(config.getReadTimeout());
            httpConnection.setConnectTimeout(config.getConnectTimeout());
            httpConnection.setInstanceFollowRedirects(config.isFollowRedirects());
            return httpConnection;
        }
        catch (IOException e) {
            throw new UtilsException("\u4e0d\u80fd\u83b7\u53d6Url\u8fde\u63a5", e, UtilsType.HTTP);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilsException("Https\u8bc1\u4e66\u7b97\u6cd5\u5f02\u5e38", e, UtilsType.HTTP);
        }
        catch (KeyManagementException e) {
            throw new UtilsException("Https\u8bc1\u4e66\u5f02\u5e38", e, UtilsType.HTTP);
        }
    }

    protected JdkHttpResponse doConnect(HttpURLConnection connection, AbstractBuilder builder) {
        try {
            connection.connect();
            if (builder instanceof MultipartBuilder) {
                this.writeMultipartContent(connection, (MultipartBuilder)builder);
            } else if (builder instanceof StreamBuilder) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(((StreamBuilder)builder).getStream());
                outputStream.flush();
                outputStream.close();
            } else {
                this.writeUrlEncodingContent(connection, (UrlBuilder)builder);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode < 400) {
                JdkHttpResponse jdkHttpResponse = new JdkHttpResponse(responseCode, this.getResponseContent(connection), connection);
                return jdkHttpResponse;
            }
            InputStream errorStream = connection.getErrorStream();
            if (null == errorStream) {
                JdkHttpResponse jdkHttpResponse = new JdkHttpResponse(responseCode, null, connection);
                return jdkHttpResponse;
            }
            JdkHttpResponse jdkHttpResponse = new JdkHttpResponse(responseCode, CommonUtils.read(errorStream), connection);
            return jdkHttpResponse;
        }
        catch (IOException e) {
            throw new UtilsException("\u53d1\u9001Http\u8bf7\u6c42\u5931\u8d25", e, UtilsType.HTTP);
        }
        finally {
            connection.disconnect();
        }
    }

    private void writeUrlEncodingContent(HttpURLConnection connection, UrlBuilder builder) throws IOException {
        String requestMethod = connection.getRequestMethod();
        if ("GET".equalsIgnoreCase(requestMethod)) {
            return;
        }
        OutputStream output = connection.getOutputStream();
        List<AbstractBuilder.BodyParam> bodys = builder.getBodys();
        for (int i = 0; i < bodys.size(); ++i) {
            AbstractBuilder.BodyParam item = bodys.get(i);
            if (!CommonUtils.isNotBlank(item.getName())) {
                throw new UtilsException("\u6784\u5efaPost\u8f93\u51fa\u6d41\u5931\u8d25 \u539f\u56e0\uff1aUrlEncoded\u7c7b\u578b \u53c2\u6570name\u5fc5\u586b", UtilsType.HTTP);
            }
            output.write(item.getName().getBytes(builder.getCharset()));
            output.write("=".getBytes());
            output.write(item.getContent());
            if (i == bodys.size() - 1) continue;
            output.write("&".getBytes());
        }
        if (builder.getQuery().length() != 0) {
            if (CommonUtils.isNotEmpty(bodys)) {
                output.write(("&" + builder.getQuery().toString()).getBytes(builder.getCharset()));
            } else {
                output.write(builder.getQuery().toString().getBytes(builder.getCharset()));
            }
        }
        output.flush();
        output.close();
    }

    private byte[] getResponseContent(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        String encoding = connection.getHeaderField("Content-Encoding");
        if (null == encoding) {
            return CommonUtils.read(inputStream);
        }
        if ("gzip".equals(encoding) || "x-gzip".equals(encoding)) {
            inputStream = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(encoding)) {
            inputStream = new DeflaterInputStream(inputStream);
        } else if (!"identity".equals(encoding)) {
            throw new UtilsException("\u4e0d\u652f\u6301\u7684\u5185\u5bb9\u7f16\u7801\uff1a" + encoding, UtilsType.HTTP);
        }
        return CommonUtils.read(inputStream);
    }

    protected void writeMultipartContent(HttpURLConnection connection, MultipartBuilder builder) throws IOException {
        try (OutputStream output = connection.getOutputStream();
             ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            List<AbstractBuilder.BodyParam> bodys = builder.getBodys();
            if (CommonUtils.isNotEmpty(bodys)) {
                for (AbstractBuilder.BodyParam item : bodys) {
                    stream.write((PREFIX + builder.getBoundary() + ENTER).getBytes());
                    stream.write((item.contentDisposition() + ENTER).getBytes());
                    stream.write(ENTER_BYTES);
                    stream.write(item.getContent());
                    stream.write(ENTER_BYTES);
                }
                stream.write((PREFIX + builder.getBoundary() + PREFIX + ENTER).getBytes());
                byte[] bytes = stream.toByteArray();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("http\u5b9e\u4f53\u5185\u5bb9\uff1a{}", (Object)new String(bytes, "utf-8"));
                }
                output.write(bytes);
                output.flush();
            }
        }
    }

    protected void setHeaders(HttpURLConnection connection, AbstractBuilder builder) {
        Iterator<HttpHeader> iterator = builder.iterator();
        iterator.forEachRemaining(item -> connection.setRequestProperty(item.getName(), item.getValue()));
        if (builder instanceof MultipartBuilder) {
            connection.setRequestProperty("Content-Type", builder.getType().type + "; boundary=" + ((MultipartBuilder)builder).getBoundary());
        } else {
            connection.setRequestProperty("Content-Type", builder.getType().type);
        }
    }
}

