/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.adapter;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpClientResponse
implements HttpResponse {
    private byte[] content;
    private StatusLine statusLine;
    private CloseableHttpResponse response;

    public HttpClientResponse(CloseableHttpResponse response) {
        this.response = response;
        this.statusLine = response.getStatusLine();
    }

    @Override
    public int getStatus() {
        return this.statusLine.getStatusCode();
    }

    @Override
    public boolean isOk() {
        return this.statusLine.getStatusCode() == 200;
    }

    @Override
    public String getMessage() {
        return this.statusLine.getReasonPhrase();
    }

    @Override
    public byte[] getContent() {
        if (CommonUtils.isNotEmpty(this.content)) {
            return this.content;
        }
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity == null) {
                return null;
            }
            InputStream inputStream = entity.getContent();
            this.content = CommonUtils.read(inputStream);
            return this.content;
        }
        catch (IOException e) {
            throw new UtilsException("\u8bfb\u53d6\u54cd\u5e94\u6d41\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    @Override
    public String getContent(String charset) {
        try {
            if (CommonUtils.isNotEmpty(this.getContent())) {
                return new String(this.content, charset);
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException("\u4e0d\u652f\u6301\u7684\u7f16\u7801", e, UtilsType.HTTP);
        }
    }

    @Override
    public String getHeader(String name) {
        return this.response.getHeaders(name).toString();
    }

    @Override
    public String getContentEncoding() {
        return this.response.getHeaders("Content-Encoding").toString();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

