/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http.adapter;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.AbstractBuilder;
import com.iteaj.util.module.http.ContentType;
import com.iteaj.util.module.http.HttpAdapter;
import com.iteaj.util.module.http.HttpHeader;
import com.iteaj.util.module.http.HttpRequestConfig;
import com.iteaj.util.module.http.adapter.HttpClientResponse;
import com.iteaj.util.module.http.build.MultipartBuilder;
import com.iteaj.util.module.http.build.StreamBuilder;
import com.iteaj.util.module.http.build.UrlBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientAdapter
implements HttpAdapter<HttpClientResponse> {
    private static RequestConfig config;
    private static Object syncLock;
    private static CloseableHttpClient httpClient;
    private static HttpClientAdapter httpClientAdapter;
    private static PoolingHttpClientConnectionManager connectionManager;

    protected HttpClientAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientAdapter instance() {
        if (null != httpClientAdapter) {
            return httpClientAdapter;
        }
        Object object = syncLock;
        synchronized (object) {
            if (null != httpClientAdapter) {
                return httpClientAdapter;
            }
            HttpRequestConfig config = UtilsFactory.getDefaultRequestConfig();
            connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(config.getMaxTotal());
            connectionManager.setDefaultMaxPerRoute(config.getDefaultMaxPerRoute());
            HttpClientAdapter.config = RequestConfig.custom().setSocketTimeout(config.getReadTimeout()).setConnectTimeout(config.getConnectTimeout()).setRedirectsEnabled(config.isFollowRedirects()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).build();
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(HttpClientAdapter.config).build();
            httpClientAdapter = new HttpClientAdapter();
            return httpClientAdapter;
        }
    }

    @Override
    public HttpClientResponse get(UrlBuilder builder) throws UtilsException {
        AssertUtils.isTrue(null != builder, "\u672a\u6307\u5b9a\u53c2\u6570\u6784\u5efa\u5668", UtilsType.HTTP);
        try {
            HttpGet get = new HttpGet(builder.parseUrl());
            this.setHeader(builder, (HttpRequestBase)get);
            this.setRequestConfig((HttpRequestBase)get, builder.getRequestConfig());
            return new HttpClientResponse(httpClient.execute((HttpUriRequest)get));
        }
        catch (IOException e) {
            throw new UtilsException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    @Override
    public HttpClientResponse post(UrlBuilder builder) throws UtilsException {
        AssertUtils.isTrue(null != builder, "\u672a\u6307\u5b9a\u53c2\u6570\u6784\u5efa\u5668", UtilsType.HTTP);
        try {
            HttpPost post = new HttpPost(builder.getUrl().toString());
            this.setHeader(builder, (HttpRequestBase)post);
            this.setRequestConfig((HttpRequestBase)post, builder.getRequestConfig());
            List<AbstractBuilder.BodyParam> bodys = builder.getBodys();
            if (CommonUtils.isNotEmpty(bodys)) {
                ArrayList<BasicNameValuePair> urlParam = new ArrayList<BasicNameValuePair>();
                for (AbstractBuilder.BodyParam body : bodys) {
                    urlParam.add(new BasicNameValuePair(body.getName(), new String(body.getContent(), new String(body.getContent(), builder.getCharset()))));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(urlParam, builder.getCharset());
                post.setEntity((HttpEntity)entity);
            }
            return new HttpClientResponse(httpClient.execute((HttpUriRequest)post));
        }
        catch (IOException e) {
            throw new UtilsException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    @Override
    public HttpClientResponse post(StreamBuilder builder) throws UtilsException {
        AssertUtils.isTrue(null != builder, "\u672a\u6307\u5b9a\u53c2\u6570\u6784\u5efa\u5668", UtilsType.HTTP);
        try {
            HttpPost post = new HttpPost(builder.parseUrl());
            this.setHeader(builder, (HttpRequestBase)post);
            this.setRequestConfig((HttpRequestBase)post, builder.getRequestConfig());
            post.setEntity((HttpEntity)new ByteArrayEntity(builder.getStream(), this.convertType(builder.getType())));
            return new HttpClientResponse(httpClient.execute((HttpUriRequest)post));
        }
        catch (IOException e) {
            throw new UtilsException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    private void setRequestConfig(HttpRequestBase post, HttpRequestConfig requestConfig) {
        HttpRequestConfig defaultRequestConfig = UtilsFactory.getDefaultRequestConfig();
        if (requestConfig != null && requestConfig != defaultRequestConfig) {
            post.setConfig(this.convertConfig(requestConfig));
        }
    }

    @Override
    public HttpClientResponse post(MultipartBuilder builder) throws UtilsException {
        AssertUtils.isTrue(null != builder, "\u672a\u6307\u5b9a\u53c2\u6570\u6784\u5efa\u5668", UtilsType.HTTP);
        try {
            HttpPost post = new HttpPost(builder.parseUrl());
            this.setHeader(builder, (HttpRequestBase)post);
            this.setRequestConfig((HttpRequestBase)post, builder.getRequestConfig());
            List<AbstractBuilder.BodyParam> entitys = builder.getBodys();
            if (CommonUtils.isNotEmpty(entitys)) {
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                for (AbstractBuilder.BodyParam body : entitys) {
                    if (body.getFileName() != null) {
                        entityBuilder.addBinaryBody(body.getName(), body.getContent(), this.convertType(body.getType()), body.getFileName());
                        continue;
                    }
                    entityBuilder.addBinaryBody(body.getName(), body.getContent());
                }
                HttpEntity entity = entityBuilder.build();
                post.setEntity(entity);
            }
            return new HttpClientResponse(httpClient.execute((HttpUriRequest)post));
        }
        catch (IOException e) {
            throw new UtilsException("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", e, UtilsType.HTTP);
        }
    }

    private void setHeader(AbstractBuilder builder, HttpRequestBase get) {
        Iterator<HttpHeader> iterator = builder.iterator();
        while (iterator.hasNext()) {
            HttpHeader next = iterator.next();
            get.addHeader(next.getName(), next.getValue());
        }
    }

    org.apache.http.entity.ContentType convertType(ContentType type) {
        switch (type) {
            case OctetStream: {
                return org.apache.http.entity.ContentType.APPLICATION_OCTET_STREAM;
            }
            case Multipart: {
                return org.apache.http.entity.ContentType.MULTIPART_FORM_DATA;
            }
            case UrlEncoded: {
                return org.apache.http.entity.ContentType.APPLICATION_FORM_URLENCODED;
            }
            case Plain: {
                return org.apache.http.entity.ContentType.TEXT_PLAIN;
            }
            case Xml: {
                return org.apache.http.entity.ContentType.APPLICATION_XML;
            }
            case Json: {
                return org.apache.http.entity.ContentType.APPLICATION_JSON;
            }
            case Html: {
                return org.apache.http.entity.ContentType.TEXT_HTML;
            }
        }
        return org.apache.http.entity.ContentType.TEXT_PLAIN;
    }

    RequestConfig convertConfig(HttpRequestConfig config) {
        return RequestConfig.custom().setSocketTimeout(config.getReadTimeout()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).setConnectTimeout(config.getConnectTimeout()).setRedirectsEnabled(config.isFollowRedirects()).build();
    }

    static {
        syncLock = new Object();
    }
}

