/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.http;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.Const;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.ContentType;
import com.iteaj.util.module.http.HttpHeader;
import com.iteaj.util.module.http.HttpHeaderBuilder;
import com.iteaj.util.module.http.HttpRequestConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractBuilder<This extends AbstractBuilder>
implements HttpHeaderBuilder {
    private String charset;
    protected ContentType type;
    protected String url;
    protected StringBuilder query;
    protected List<BodyParam> bodys;
    protected Map<String, HttpHeader> headers;
    protected HttpRequestConfig requestConfig;
    private static byte[] EMPTY_CONTENT = new byte[0];
    private static Map<String, HttpHeader> defaultHead = new HashMap<String, HttpHeader>();

    public AbstractBuilder(String url, String charset) {
        this(url, charset, ContentType.UrlEncoded, UtilsFactory.getDefaultRequestConfig());
    }

    public AbstractBuilder(String url, String charset, ContentType type) {
        this(url, charset, type, UtilsFactory.getDefaultRequestConfig());
    }

    public AbstractBuilder(String url, ContentType type) {
        this(url, type.charset, type, UtilsFactory.getDefaultRequestConfig());
    }

    public AbstractBuilder(String url, String charset, ContentType type, HttpRequestConfig requestConfig) {
        this.url = url;
        this.type = type;
        this.charset = charset;
        this.bodys = new ArrayList<BodyParam>();
        this.query = new StringBuilder();
        this.requestConfig = requestConfig;
        this.headers = new HashMap<String, HttpHeader>(defaultHead);
    }

    public This addQueryParam(String name, String value) {
        AssertUtils.isNotBlank(name, "\u672a\u6307\u5b9a\u8bf7\u6c42\u53c2\u6570\u540d", UtilsType.HTTP);
        if (this.query.length() == 0) {
            this.query.append(name).append('=').append(value);
        } else {
            this.query.append('&').append(name).append('=').append(value);
        }
        return (This)this;
    }

    public This setQueryParam(String query) {
        this.getQuery().append(query);
        return (This)this;
    }

    public This addBody(String name, String value) {
        this.bodys.add(new BodyParam(name, value, Const.UTF_8.name()));
        return (This)this;
    }

    public This addHeader(String name, String value) {
        AssertUtils.isNotBlank(name, "\u672a\u6307\u5b9a\u8bf7\u6c42\u5934\u540d\u79f0", UtilsType.HTTP);
        AssertUtils.isNotBlank(value, "\u672a\u6307\u5b9a\u8bf7\u6c42\u5934\u503c\uff1a" + name, UtilsType.HTTP);
        this.headers.put(name, new HttpHeader(name, value));
        return (This)this;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public String parseUrl() {
        int indexOf = this.url.indexOf("?");
        if (-1 != indexOf) {
            return this.url + "&" + this.getQuery().toString();
        }
        return this.url + '?' + this.getQuery().toString();
    }

    public List<BodyParam> getBodys() {
        return this.bodys;
    }

    public String getUrl() {
        return this.url;
    }

    public StringBuilder getQuery() {
        return this.query;
    }

    public ContentType getType() {
        return this.type;
    }

    public HttpRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public AbstractBuilder setRequestConfig(HttpRequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    protected void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setType(ContentType type) {
        this.type = type;
    }

    static {
        defaultHead.put("Accept", new HttpHeader("Accept", "*/*"));
        defaultHead.put("Connection", new HttpHeader("Connection", "Keep-Alive"));
        defaultHead.put("Cache-Control", new HttpHeader("Cache-Control", "no-cache"));
        defaultHead.put("Accept-Encoding", new HttpHeader("Accept-Encoding", "gzip, deflate"));
    }

    public class BodyParam {
        private String name;
        private byte[] content;
        private String fileName;
        private ContentType type;

        public BodyParam(String name, String value) {
            this(name, value, Const.UTF_8.name(), ContentType.Plain);
        }

        public BodyParam(String name, String value, String charset) {
            this(name, value, charset, ContentType.Plain);
        }

        public BodyParam(String name, String value, String charset, ContentType type) {
            this(name, value.getBytes(Charset.forName(charset)), null, type);
        }

        public BodyParam(String name, byte[] content, String fileName, ContentType type) {
            this.type = type;
            this.name = name;
            this.content = content;
            this.fileName = fileName;
        }

        public byte[] getContent() {
            if (CommonUtils.isNotEmpty(this.content)) {
                return this.content;
            }
            this.content = EMPTY_CONTENT;
            return this.content;
        }

        public BodyParam setContent(byte[] content) {
            this.content = content;
            return this;
        }

        public ContentType getType() {
            return this.type;
        }

        public BodyParam setType(ContentType type) {
            this.type = type;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String contentDisposition() {
            StringBuilder sb = new StringBuilder();
            sb.append("Content-Disposition: form-data; name=\"").append(this.getName()).append('\"');
            if (this.getFileName() != null) {
                sb.append("; filename=\"").append(this.getFileName()).append("\"\r\n").append("Content-Type: octet-stream").append("\r\n").append("Content-Transfer-Encoding: binary\r\n");
            } else if (ContentType.OctetStream == this.getType()) {
                sb.append("\r\n").append("Content-Type: octet-stream").append("\r\n").append("Content-Transfer-Encoding: binary");
            } else {
                sb.append("\r\n").append("Content-Type: text/plain; charset=").append(AbstractBuilder.this.getCharset()).append("\r\n").append("Content-Transfer-Encoding: 8bit");
            }
            return sb.toString();
        }
    }
}

