/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.record;

import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.RecordType;
import com.iteaj.util.module.aop.WeaveAction;
import java.util.Date;

public class TimeRecord
implements ActionRecord {
    private long time;
    private Date date;
    private RecordType recordType;
    private WeaveAction action;

    public TimeRecord() {
        this(null, 0L);
    }

    public TimeRecord(WeaveAction action, long time) {
        this.time = time;
        this.action = action;
        this.date = new Date();
        this.recordType = RecordType.Time;
    }

    @Override
    public String getId() {
        return this.recordType.name();
    }

    @Override
    public String generate() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"time(ms)\":").append(this.getTime()).append(',').append("\"id\":\"").append(this.getId()).append("\",").append("\"desc\":\"").append(this.getDesc()).append("\",").append("\"class\":\"").append(this.getAction().getTarget().getName()).append("\",").append("\"method\":\"").append(this.getAction().getMethod().getName()).append("\",").append("\"dateTime\":\"").append(this.getDate()).append("\"").append("}");
        return sb.toString();
    }

    @Override
    public String getDesc() {
        return this.recordType.getName();
    }

    public void setRecordType(RecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public WeaveAction getAction() {
        return this.action;
    }

    public void setAction(WeaveAction action) {
        this.action = action;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u8017\u65f6(ms)\uff1a").append(this.time).append("-").append("\u6267\u884c\u65f6\u95f4\uff1a").append(this.getDate()).append("-").append("\u6267\u884c\u65b9\u6cd5\uff1a").append(this.action.getTarget().getName()).append('.').append(this.action.getMethod().getName());
        return sb.toString();
    }
}

