/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.record;

import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.RecordType;
import com.iteaj.util.module.aop.WeaveAction;
import java.util.Date;

public class ExceptionRecord
implements ActionRecord {
    private RecordType type;
    private Throwable throwable;
    private WeaveAction action;

    public ExceptionRecord() {
        this(null, null);
    }

    public ExceptionRecord(Throwable throwable, WeaveAction action) {
        this.action = action;
        this.throwable = throwable;
        this.type = RecordType.Exception;
    }

    @Override
    public String getId() {
        return this.type.name();
    }

    @Override
    public String generate() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"errMsg\":\"").append(this.throwable.getMessage()).append("\",").append("\"id\":\"").append(this.getId()).append("\",").append("\"desc\":\"").append(this.getDesc()).append("\",").append("\"class\":\"").append(this.action.getTarget().getName()).append("\",").append("\"method\":\"").append(this.action.getMethod().getName()).append("\",").append("\"dateTime\":\"").append(this.getDate()).append("\"").append("}");
        return sb.toString();
    }

    @Override
    public String getDesc() {
        return this.type.getName();
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    @Override
    public WeaveAction getAction() {
        return this.action;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setAction(WeaveAction action) {
        this.action = action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u5f02\u5e38\u65f6\u95f4\uff1a").append(this.getDate()).append("<br />");
        sb.append(this.throwable.getMessage()).append("<br />");
        for (StackTraceElement item : this.throwable.getStackTrace()) {
            sb.append("at ").append(item.getClassName()).append('.').append(item.getMethodName()).append('(').append(item.getFileName()).append(':').append(item.getLineNumber()).append(')').append("<br />");
        }
        return sb.toString();
    }
}

