/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.output;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.module.aop.ActionOutput;
import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.record.ExceptionRecord;
import com.iteaj.util.module.aop.record.VoidRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class Slf4JActionOutput
extends ActionOutput
implements InitializingBean {
    public Logger logger;
    private String loggerName;

    @Override
    public void write(ActionRecord record) {
        if (record instanceof ExceptionRecord) {
            Throwable throwable = ((ExceptionRecord)record).getThrowable();
            this.logger.warn("AopExt - {}", (Object)record.generate(), (Object)throwable);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("AopExt - {}", (Object)record.generate(), (Object)record.getDate());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("AopExt - {}", (Object)record.generate(), (Object)record.getDate());
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("AopEx - {}", (Object)record.generate(), (Object)record.getDate());
        }
    }

    @Override
    public boolean isMatching(ActionRecord record) {
        return record instanceof ActionRecord && !(record instanceof VoidRecord);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void afterPropertiesSet() throws Exception {
        if (!CommonUtils.isBlank(this.loggerName)) {
            this.loggerName = "Slf4jMonitoring";
        }
        this.logger = LoggerFactory.getLogger((String)this.getLoggerName());
    }

    @Override
    public void setStart(boolean start) {
        super.setStart(start);
    }
}

