/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.output;

import com.iteaj.util.module.aop.ActionOutput;
import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.record.ExceptionRecord;
import com.iteaj.util.module.aop.record.TimeRecord;
import com.iteaj.util.module.aop.record.VoidRecord;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;

public class EmailAlarmOutput
extends ActionOutput
implements InitializingBean,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private boolean errorAlarm;
    private boolean timeoutAlarm;
    private long timeout;
    private boolean async = true;
    private String email;
    private String title = "\u90ae\u4ef6\u8b66\u62a5";
    private String fromMail;
    private Executor executor;
    private JavaMailSender javaMailSender;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void write(ActionRecord record) {
        if (record instanceof ExceptionRecord && this.errorAlarm) {
            this.send(this.fromMail, this.email, this.title, this.getSendContent(record), this.async);
        }
        if (record instanceof TimeRecord && this.timeoutAlarm && ((TimeRecord)record).getTime() > this.timeout) {
            long timeout = ((TimeRecord)record).getTime() - this.timeout;
            StringBuilder sb = new StringBuilder("\u8d85\u65f6(ms)\uff1a").append(timeout).append("  \u5177\u4f53\u4fe1\u606f\u5982\u4e0b\uff1a");
            this.send(this.fromMail, this.email, this.title, sb.toString() + this.getSendContent(record), this.async);
        }
    }

    @Override
    public boolean isMatching(ActionRecord record) {
        return !(record instanceof VoidRecord);
    }

    protected String getSendContent(ActionRecord record) {
        return record.generate();
    }

    protected void send(String fromMail, String toMail, String subject, String content, boolean async) {
        try {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
            mimeMessageHelper.setFrom(fromMail);
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setTo(toMail);
            mimeMessageHelper.setText(content, true);
            if (async) {
                this.addSendTask(mimeMessage);
            } else {
                this.javaMailSender.send(mimeMessage);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private void addSendTask(final MimeMessage mimeMessage) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    EmailAlarmOutput.this.javaMailSender.send(mimeMessage);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.isStart()) {
            return;
        }
        try {
            this.javaMailSender = (JavaMailSender)this.beanFactory.getBean(JavaMailSender.class);
            Assert.hasLength((String)this.email, (String)"\u672a\u8bbe\u7f6e\u8981\u53d1\u9001\u5230\u54ea\u4e2a\u90ae\u4ef6\u5e10\u53f7");
            Assert.hasLength((String)this.fromMail, (String)"\u672a\u8bbe\u7f6e\u8981\u7528\u54ea\u4e2a\u90ae\u4ef6\u5e10\u53f7\u8fdb\u884c\u53d1\u9001");
            try {
                if (this.isAsync()) {
                    this.executor = (Executor)this.beanFactory.getBean(AsyncTaskExecutor.class);
                }
            }
            catch (BeansException e) {
                this.executor = Executors.newSingleThreadExecutor();
                this.logger.warn("\u7c7b\u522b\uff1aAop - \u52a8\u4f5c\uff1a\u90ae\u4ef6\u8f93\u51fa - \u63cf\u8ff0\uff1a\u672a\u627e\u5230\u5bf9\u8c61 {} \u5c06\u521b\u5efa\u9ed8\u8ba4\u7ebf\u7a0b\u6c60" + Executor.class.getName());
            }
        }
        catch (IllegalArgumentException e) {
            this.setStart(false);
            this.logger.warn("\u7c7b\u522b\uff1aAop - \u52a8\u4f5c\uff1a\u90ae\u4ef6\u8f93\u51fa - \u63cf\u8ff0\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        catch (BeansException e) {
            this.setStart(false);
            this.logger.warn("\u7c7b\u522b\uff1aAop - \u52a8\u4f5c\uff1a\u90ae\u4ef6\u8f93\u51fa - \u63cf\u8ff0\uff1a\u90ae\u4ef6\u8f93\u51fa\u5bf9\u8c61\u521d\u59cb\u5316\u5f02\u5e38,\u5c06\u5bfc\u81f4\u6ca1\u529e\u6cd5\u53d1\u9001\u90ae\u4ef6", (Throwable)e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isErrorAlarm() {
        return this.errorAlarm;
    }

    public void setErrorAlarm(boolean errorAlarm) {
        this.errorAlarm = errorAlarm;
    }

    public boolean isTimeoutAlarm() {
        return this.timeoutAlarm;
    }

    public void setTimeoutAlarm(boolean timeoutAlarm) {
        this.timeoutAlarm = timeoutAlarm;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getFromMail() {
        return this.fromMail;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }
}

