/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.factory.time;

import com.iteaj.util.module.aop.AbstractWeaveActionFactory;
import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.RecordType;
import com.iteaj.util.module.aop.WeaveAction;
import com.iteaj.util.module.aop.record.TimeRecord;
import java.lang.reflect.Method;

public abstract class TimeWeaveActionFactory
extends AbstractWeaveActionFactory {
    protected WeaveAction getWeaveAction(Method method, Class target) {
        final TimeWeaveActionFactory handle = this;
        return new WeaveAction<TimeRecord>(method, target){
            private long afterTime;
            private long beforeTime;
            private boolean isException;

            @Override
            public String getIdentifier() {
                return handle.getIdentifier();
            }

            @Override
            protected void beforeMethodAction(Object ori, Object ... args) {
                this.beforeTime = System.currentTimeMillis();
            }

            @Override
            protected void afterMethodAction(Object ori, Object returnVal, Object ... args) {
                this.afterTime = System.currentTimeMillis();
            }

            @Override
            public void throwableAction(Throwable throwable, Object ori, Object ... args) {
                this.isException = true;
            }

            @Override
            protected TimeRecord createRecord() throws IllegalAccessException, InstantiationException {
                TimeRecord instance = (TimeRecord)TimeWeaveActionFactory.this.getRecord().newInstance();
                instance.setTime(this.afterTime - this.beforeTime);
                instance.setAction(this);
                if (this.isException) {
                    instance.setRecordType(RecordType.Exception);
                }
                return instance;
            }
        };
    }

    public abstract String getIdentifier();

    @Override
    public boolean isMatchingRecord(Class<? extends ActionRecord> clazz) {
        if (clazz == null) {
            return false;
        }
        return TimeRecord.class.isAssignableFrom(clazz);
    }
}

