/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop.factory;

import com.iteaj.util.module.aop.AbstractWeaveActionFactory;
import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.AopExtendUtils;
import com.iteaj.util.module.aop.WeaveAction;
import com.iteaj.util.module.aop.record.ExceptionRecord;
import java.lang.reflect.Method;

public class ExceptionWeaveActionFactory
extends AbstractWeaveActionFactory {
    private boolean isDao;
    private boolean isBusiness;
    private boolean isController;

    @Override
    protected WeaveAction getWeaveAction(Method method, Class<?> target) {
        return new WeaveAction<ExceptionRecord>(method, target){
            private Throwable throwable;

            @Override
            public String getIdentifier() {
                return "Exception";
            }

            @Override
            protected void beforeMethodAction(Object ori, Object ... args) {
            }

            @Override
            protected void afterMethodAction(Object ori, Object returnVal, Object ... args) {
            }

            @Override
            public void throwableAction(Throwable throwable, Object ori, Object ... args) {
                this.throwable = throwable;
            }

            @Override
            protected ExceptionRecord createRecord() throws IllegalAccessException, InstantiationException {
                if (this.throwable != null) {
                    ExceptionRecord record = (ExceptionRecord)ExceptionWeaveActionFactory.this.getRecord().newInstance();
                    record.setAction(this);
                    record.setThrowable(this.throwable);
                    return record;
                }
                return null;
            }
        };
    }

    @Override
    public boolean isMonitoring(Method method, Class<?> targetClass) {
        if (this.isDao && AopExtendUtils.isDao(method, targetClass)) {
            return true;
        }
        if (this.isController && AopExtendUtils.isController(method, targetClass)) {
            return true;
        }
        return this.isBusiness && AopExtendUtils.isBusiness(method, targetClass);
    }

    @Override
    public boolean isMatchingRecord(Class<? extends ActionRecord> clazz) {
        if (null == clazz) {
            return false;
        }
        return ExceptionRecord.class.isAssignableFrom(clazz);
    }

    public boolean isDao() {
        return this.isDao;
    }

    public void setDao(boolean dao) {
        this.isDao = dao;
    }

    public boolean isBusiness() {
        return this.isBusiness;
    }

    public void setBusiness(boolean business) {
        this.isBusiness = business;
    }

    public boolean isController() {
        return this.isController;
    }

    public void setController(boolean controller) {
        this.isController = controller;
    }
}

