/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop;

import com.iteaj.util.module.aop.ActionRecord;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WeaveAction<T extends ActionRecord> {
    private Method method;
    private Class<?> target;
    private T actionRecord;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public WeaveAction(Method method, Class<?> target) {
        this.method = method;
        this.target = target;
    }

    public abstract String getIdentifier();

    protected abstract void beforeMethodAction(Object var1, Object ... var2);

    protected abstract void afterMethodAction(Object var1, Object var2, Object ... var3);

    public abstract void throwableAction(Throwable var1, Object var2, Object ... var3);

    protected final T generateRecord() {
        try {
            this.actionRecord = this.createRecord();
            return this.actionRecord;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract T createRecord() throws IllegalAccessException, InstantiationException;

    public ActionRecord getActionRecord() {
        return this.actionRecord;
    }

    protected void setActionRecord(T actionRecord) {
        this.actionRecord = actionRecord;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }
}

