/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.module.aop.AbstractWeaveActionFactory;
import com.iteaj.util.module.aop.ActionOutput;
import com.iteaj.util.module.aop.ActionRecord;
import com.iteaj.util.module.aop.WeaveAction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;

public abstract class RoundAdviceAbstract
implements MethodInterceptor,
InitializingBean {
    private static List<WeaveAction> EMPTY_ACTION = new ArrayList<WeaveAction>();
    private static Collection<ActionOutput> _COLLECTION;
    private static Map<Method, Set<AbstractWeaveActionFactory>> methodActionMapping;

    public RoundAdviceAbstract() {
    }

    public RoundAdviceAbstract(Collection<ActionOutput> collection, Map<Method, Set<AbstractWeaveActionFactory>> methodActionMapping) {
        _COLLECTION = collection;
        RoundAdviceAbstract.methodActionMapping = methodActionMapping;
    }

    public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object proceed;
        Method method = methodInvocation.getMethod();
        Object aThis = methodInvocation.getThis();
        List<WeaveAction> actions = null;
        try {
            actions = this.getWeaveActions(method, aThis);
            this.beforeMethodAction(methodInvocation, actions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            proceed = methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            this.throwableAction(throwable, methodInvocation, actions);
            this.writeRecord(actions);
            throw throwable;
        }
        try {
            this.afterMethodAction(methodInvocation, actions, proceed);
            this.writeRecord(actions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proceed;
    }

    protected List<WeaveAction> getWeaveActions(Method method, Object oriThis) {
        Set<AbstractWeaveActionFactory> factorySet = methodActionMapping.get(method);
        if (!CommonUtils.isNotEmpty(factorySet)) {
            return EMPTY_ACTION;
        }
        Iterator<AbstractWeaveActionFactory> iterator = factorySet.iterator();
        ArrayList<WeaveAction> actionList = new ArrayList<WeaveAction>();
        while (iterator.hasNext()) {
            WeaveAction monitoringAction = iterator.next().getWeaveAction(method, oriThis.getClass());
            if (null == monitoringAction) continue;
            actionList.add(monitoringAction);
        }
        return actionList;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public Map<Method, Set<AbstractWeaveActionFactory>> getMethodActionMapping() {
        return methodActionMapping;
    }

    public void setMethodActionMapping(Map<Method, Set<AbstractWeaveActionFactory>> methodActionMapping) {
        RoundAdviceAbstract.methodActionMapping = methodActionMapping;
    }

    protected abstract void beforeMethodAction(MethodInvocation var1, List<WeaveAction> var2);

    protected abstract void afterMethodAction(MethodInvocation var1, List<WeaveAction> var2, Object var3);

    protected abstract void throwableAction(Throwable var1, MethodInvocation var2, List<WeaveAction> var3);

    protected void writeRecord(List<WeaveAction> actions) throws Exception {
        for (ActionOutput next : _COLLECTION) {
            for (WeaveAction item : actions) {
                ActionRecord record = item.getActionRecord();
                if (null == record || !next.isStart() || !next.isMatching(record)) continue;
                next.write(record);
            }
        }
    }

    protected Collection<ActionOutput> getOutputs() {
        return _COLLECTION;
    }
}

