/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.aop;

import com.iteaj.util.CommonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class AopExtendUtils {
    public static boolean objectMethod(Method method) {
        Class<?> declaring = method.getDeclaringClass();
        return Object.class == declaring;
    }

    public static boolean isController(Method method, Class targetClass) {
        RequestMapping methodAnnotation;
        Controller annotation = targetClass.getAnnotation(Controller.class);
        return null != annotation && null != (methodAnnotation = method.getAnnotation(RequestMapping.class));
    }

    public static boolean isBusiness(Method method, Class targetClass) {
        Service annotation = targetClass.getAnnotation(Service.class);
        if (null != annotation) {
            return !AopExtendUtils.objectMethod(method);
        }
        return false;
    }

    public static boolean isDao(Method method, Class targetClass) {
        Repository annotation;
        Object targetInterfaces = targetClass;
        if (Proxy.isProxyClass(targetClass)) {
            Object[] interfaces = targetClass.getInterfaces();
            if (CommonUtils.isNotEmpty(interfaces)) {
                targetInterfaces = interfaces[0];
            }
            if (targetInterfaces == null) {
                return false;
            }
        }
        if (null != (annotation = ((Class)targetInterfaces).getAnnotation(Repository.class))) {
            return !AopExtendUtils.objectMethod(method);
        }
        return false;
    }
}

