/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.alipay.auth;

import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.alipay.AliPAdaptor;
import com.iteaj.util.module.alipay.AliRAdaptor;
import com.iteaj.util.module.alipay.auth.AbstractAliAOauth2;
import com.iteaj.util.module.alipay.auth.AliCWebAuthorize;
import com.iteaj.util.module.alipay.auth.AliPWebAuthorize;
import com.iteaj.util.module.alipay.auth.AliScope;
import com.iteaj.util.module.alipay.auth.AliWebResult;
import com.iteaj.util.module.oauth2.AbstractAuthorizePhase;
import com.iteaj.util.module.oauth2.AbstractAuthorizeResult;
import com.iteaj.util.module.oauth2.AuthorizePhase;
import com.iteaj.util.module.oauth2.PhaseChain;
import com.iteaj.util.spring.ApiManager;
import java.io.IOException;
import java.io.PrintWriter;

public class AliAWebAuthorize
extends AbstractAliAOauth2<AliCWebAuthorize, AliPWebAuthorize> {
    public AliAWebAuthorize(AliCWebAuthorize config) {
        super(config);
    }

    @Override
    public String getDescription() {
        return "\u652f\u4ed8\u5b9dweb\u6388\u6743";
    }

    @Override
    public AuthorizePhase getPhaseEntry() {
        return new EntryPhase(new UserPhase(null));
    }

    @Override
    public String getProcessStage() {
        return "entry -> user";
    }

    @Override
    public AbstractAuthorizeResult authorizeResult() {
        return new AliWebResult();
    }

    protected class UserPhase
    extends AbstractAuthorizePhase<AliPWebAuthorize> {
        public UserPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "code";
        }

        @Override
        public void doPhase(PhaseChain chain, AliPWebAuthorize context) {
            AlipayUserInfoShareRequest shareRequest;
            AlipayUserInfoShareResponse shareResponse;
            String code = context.getRequest().getParameter("auth_code");
            String state = context.getRequest().getParameter("state");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7c7b\u522b\uff1a\u652f\u4ed8\u5b9dApi - \u52a8\u4f5c\uff1a\u901a\u8fc7authorization_code\u6362\u53d6Token - code\uff1a [{}]", (Object)code);
            }
            context.addParam("code", code).addParam("state", state);
            AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
            request.setCode(code);
            request.setGrantType("authorization_code");
            AlipaySystemOauthTokenResponse response = (AlipaySystemOauthTokenResponse)((AliRAdaptor)ApiManager.invoke(new AliPAdaptor(request), new Object[0])).getResponse();
            if (!response.isSuccess()) {
                throw new UtilsException("\u652f\u4ed8\u5b9d\u6388\u6743\u83b7\u53d6token\u5931\u8d25\uff1a" + response.getMsg(), UtilsType.ALIPAY);
            }
            context.addParam("AlipaySystemOauthTokenResponse", response);
            if (context.getScope() == AliScope.auth_base) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7c7b\u522b\uff1a\u652f\u4ed8\u5b9dApi - \u52a8\u4f5c\uff1a\u901a\u8fc7accessToken\u6362\u53d6UserInfo - accessToken\uff1a [{}]", (Object)response.getAccessToken());
            }
            if (!(shareResponse = (AlipayUserInfoShareResponse)((AliRAdaptor)ApiManager.invoke(new AliPAdaptor(shareRequest = new AlipayUserInfoShareRequest(), response.getAccessToken()), new Object[0])).getResponse()).isSuccess()) {
                throw new UtilsException("\u652f\u4ed8\u5b9d\u6388\u6743\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + shareResponse.getMsg(), UtilsType.ALIPAY);
            }
            context.addParam("AlipayUserInfoShareResponse", shareResponse);
        }

        @Override
        public String getTypeAlias() {
            return AliAWebAuthorize.this.getTypeAlias();
        }
    }

    protected class EntryPhase
    extends AbstractAuthorizePhase<AliPWebAuthorize> {
        public EntryPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "entry";
        }

        @Override
        public void doPhase(PhaseChain chain, AliPWebAuthorize context) {
            try {
                String redirectUri = CommonUtils.isBlank(context.getRedirectUrl()) ? ((AliCWebAuthorize)AliAWebAuthorize.this.getApiConfig()).getRedirectUrl() : context.getRedirectUrl();
                String redirectUrl = this.getRedirectUrl(context, redirectUri);
                String domain = context.getRequest().getServerName();
                if (!redirectUrl.contains(domain)) {
                    this.logger.warn("\u7c7b\u522b\uff1a\u652f\u4ed8\u5b9dApi - \u52a8\u4f5c\uff1a\u83b7\u53d6code - \u63cf\u8ff0\uff1a{} - Domain\uff1a{} - redirectUrl\uff1a{}", new Object[]{"redirectUrl\u7684\u57df\u540d\u548c\u8bbf\u95ee\u57df\u540d\u4e0d\u4e00\u81f4, \u53ef\u80fd\u5bfc\u81f4\u8fd4\u56de\u3010redirect_uri\u53c2\u6570\u9519\u8bef\u3011", domain, redirectUrl});
                }
                StringBuilder sb = new StringBuilder(((AliCWebAuthorize)AliAWebAuthorize.this.getApiConfig()).getApiGateway());
                sb.append("?app_id=").append(((AliCWebAuthorize)AliAWebAuthorize.this.getApiConfig()).getAppId()).append("&scope=").append((Object)context.getScope()).append("&redirect_uri=").append(redirectUrl).append("&state=").append(context.getState());
                String html = String.format("<!DOCTYPE html><html lang=\"zh_cn\"><head><meta charset=\"UTF-8\"></head><body><a id=\"auto_submit\" href=\"%s\" /><script>document.getElementById(\"auto_submit\").click();</script></body></html>", sb.toString());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u7c7b\u522b\uff1a\u652f\u4ed8\u5b9dApi - \u52a8\u4f5c\uff1a\u83b7\u53d6code - \u63cf\u8ff0\uff1a\u5199html\u53c2\u6570\u5230\u652f\u4ed8\u5b9d\u5ba2\u6237\u7aef [{}]", (Object)html);
                }
                PrintWriter writer = context.getResponse().getWriter();
                context.getResponse().setContentType("text/html; charset=utf-8");
                writer.print(html);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("\u7c7b\u522b\uff1a\u652f\u4ed8\u5b9d\u6388\u6743Api - \u52a8\u4f5c\uff1a\u6267\u884c\u7f51\u9875\u6388\u6743\u9636\u6bb5 - \u63cf\u8ff0\uff1a\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            }
        }

        @Override
        public String getTypeAlias() {
            return AliAWebAuthorize.this.getTypeAlias();
        }
    }
}

