/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.core.task;

import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.core.task.TimeoutTask;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutTaskManager {
    private Thread timerThread;
    private static Object lock = new Object();
    private static TimeoutTaskManager taskManager;
    private static SortedSet<TimeoutTask> timeoutTasks;
    private static Logger logger;
    private static boolean debugEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeoutTaskManager instance() {
        if (null != taskManager) {
            return taskManager;
        }
        SortedSet<TimeoutTask> sortedSet = timeoutTasks;
        synchronized (sortedSet) {
            if (null != taskManager) {
                return taskManager;
            }
            taskManager = new TimeoutTaskManager();
            TimeoutTaskManager.taskManager.timerThread = new Thread((Runnable)new TimerThread(), "Utils-Timer");
            TimeoutTaskManager.taskManager.timerThread.start();
            return taskManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(TimeoutTask task) {
        if (null == task || task.getCreateTime() == 0L) {
            throw new UtilsException("\u4efb\u52a1\u672a\u6b63\u5e38\u6784\u5efa", UtilsType.TimeoutTask);
        }
        if (timeoutTasks.size() == 0) {
            Object object = lock;
            synchronized (object) {
                timeoutTasks.add(task);
                if (this.timerThread.getState() == Thread.State.WAITING) {
                    lock.notify();
                }
            }
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - task.getCreateTime() > task.getTimeout()) {
            try {
                task.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Object object = lock;
            synchronized (object) {
                TimeoutTask first = timeoutTasks.first();
                currentTime = System.currentTimeMillis();
                long newTaskRemain = task.getTimeout() - (currentTime - task.getCreateTime());
                long firstTaskRemain = first.getTimeout() - (currentTime - first.getCreateTime());
                Thread.State state = this.timerThread.getState();
                if (firstTaskRemain <= 0L && (state == Thread.State.TIMED_WAITING || state == Thread.State.WAITING)) {
                    lock.notify();
                }
                timeoutTasks.add(task);
                if (state == Thread.State.WAITING || newTaskRemain < firstTaskRemain) {
                    lock.notify();
                    if (debugEnabled) {
                        logger.debug("\u7c7b\u522b\uff1a\u5b9a\u65f6\u4efb\u52a1 - \u52a8\u4f5c\uff1a\u5524\u9192\u5b9a\u65f6\u7ebf\u7a0b - \u63cf\u8ff0\uff1a\u6536\u5230\u65b0\u4efb\u52a1,\u65b0\u4efb\u52a1\u7684\u8d85\u65f6\u65f6\u95f4\u5c0f\u4e8e\u7b2c\u4e00\u4e2a\u4efb\u52a1,\u5524\u9192\u5b9a\u65f6\u7ebf\u7a0b\u66f4\u6539\u7b49\u5f85\u65f6\u95f4\u4e3a\u65b0\u4efb\u52a1\u65f6\u95f4 - \u65b0\u4efb\u52a1(ms)\uff1a{} - \u7b2c\u4e00\u4e2a\u4efb\u52a1(ms)\uff1a{}", (Object)newTaskRemain, (Object)firstTaskRemain);
                    }
                }
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger((String)"UtilsTimeoutManager");
        debugEnabled = logger.isDebugEnabled();
        timeoutTasks = Collections.synchronizedSortedSet(new TreeSet());
    }

    static class TimerThread
    implements Runnable {
        TimerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object;
                        boolean alreadyTimeout;
                        if (timeoutTasks.size() == 0) {
                            try {
                                Object object2 = lock;
                                synchronized (object2) {
                                    lock.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        TimeoutTask firstTask = (TimeoutTask)timeoutTasks.first();
                        long currentTime = System.currentTimeMillis();
                        long elapseTime = currentTime - firstTask.getCreateTime();
                        boolean bl = alreadyTimeout = elapseTime >= firstTask.getTimeout();
                        if (alreadyTimeout) {
                            if (debugEnabled) {
                                logger.debug("\u7c7b\u522b\uff1a\u5b9a\u65f6\u4efb\u52a1 - \u52a8\u4f5c\uff1a\u6267\u884c\u5b9a\u65f6\u4efb\u52a1 - \u63cf\u8ff0\uff1a\u4efb\u52a1\u5b9a\u65f6\u65f6\u95f4\u5df2\u5230,\u5f00\u59cb\u6267\u884c\u4efb\u52a1 - \u5b9a\u65f6(ms)\uff1a{} - \u8bef\u5dee(ms)\uff1a{}", (Object)firstTask.getTimeout(), (Object)(elapseTime - firstTask.getTimeout()));
                            }
                            try {
                                firstTask.run();
                            }
                            catch (Throwable e) {
                                logger.error("\u7c7b\u522b\uff1a\u5b9a\u65f6\u7ba1\u7406 - \u52a8\u4f5c\uff1a\u6267\u884c\u4efb\u52a1\u5931\u8d25 - \u63cf\u8ff0\uff1a{}", (Object)e.getMessage(), (Object)e);
                            }
                            object = lock;
                            synchronized (object) {
                                Iterator iterator = timeoutTasks.iterator();
                                while (iterator.hasNext()) {
                                    TimeoutTask next = (TimeoutTask)iterator.next();
                                    if (next != firstTask) continue;
                                    iterator.remove();
                                    break;
                                }
                                continue;
                            }
                        }
                        object = lock;
                        synchronized (object) {
                            long timeoutRemain = firstTask.getTimeout() - elapseTime;
                            if (debugEnabled) {
                                logger.debug("\u7c7b\u522b\uff1a\u5b9a\u65f6\u4efb\u52a1 - \u52a8\u4f5c\uff1a\u5b9a\u65f6\u7ebf\u7a0b\u7b49\u5f85 - \u63cf\u8ff0\uff1a\u7ebf\u7a0b\u7b49\u5f85\u76f4\u5230\u4e0b\u4e00\u4e2a\u4efb\u52a1\u8d85\u65f6 - \u7b49\u5f85\u65f6\u95f4(ms)\uff1a{}", (Object)timeoutRemain);
                            }
                            lock.wait(timeoutRemain);
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u8d85\u65f6\u7ba1\u7406\u5668\u4e2d\u65ad\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u8d85\u65f6\u7ba1\u7406\u5668\u672a\u77e5\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

