/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.core.task;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsType;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutTask
implements Runnable,
Comparable<TimeoutTask> {
    private long timeout;
    private long createTime;

    public TimeoutTask(long timeout, TimeUnit unit) {
        AssertUtils.isTrue(unit != null && unit != TimeUnit.NANOSECONDS && unit != TimeUnit.MICROSECONDS, "\u8bf7\u6307\u5b9a\u8d85\u65f6\u65f6\u95f4\u5355\u4f4d\u4e14\u5fc5\u987b\u5728\u6beb\u79d2\u4ee5\u4e0a(\u5305\u542b\u6beb\u79d2)", UtilsType.TimeoutTask);
        this.timeout = unit.toMillis(timeout);
        this.createTime = System.currentTimeMillis();
        if (timeout < 0L) {
            throw new IllegalArgumentException("\u8d85\u65f6\u65f6\u95f4\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
        }
    }

    @Override
    public int compareTo(TimeoutTask o) {
        boolean timeoutComp;
        long currentTime = System.currentTimeMillis();
        long timeout1 = currentTime - this.createTime;
        long timeout2 = currentTime - o.createTime;
        boolean thisTimeout = timeout1 > this.timeout;
        boolean compTimeout = timeout2 > o.timeout;
        boolean bl = timeoutComp = this.timeout - timeout1 > o.timeout - timeout2;
        if (thisTimeout && compTimeout) {
            if (timeoutComp) {
                return -1;
            }
            return 1;
        }
        if (thisTimeout) {
            return -1;
        }
        if (compTimeout) {
            return 1;
        }
        if (timeoutComp) {
            return 1;
        }
        return -1;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

