/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.TokenManager;
import com.iteaj.util.module.http.HttpAdapter;
import com.iteaj.util.module.http.HttpRequestConfig;
import com.iteaj.util.module.http.SSLContextManager;
import com.iteaj.util.module.http.adapter.HttpClientAdapter;
import com.iteaj.util.module.http.adapter.JdkHttpAdapter;
import com.iteaj.util.module.json.JsonAdapter;
import com.iteaj.util.module.json.fastjson.FastJsonAdapter;
import com.iteaj.util.module.json.jackson.JacksonAdapter;
import com.iteaj.util.module.oauth2.AuthorizeStorageManager;
import com.iteaj.util.module.oauth2.MapStorageManager;
import com.iteaj.util.module.wechat.WechatTokenManager;
import com.iteaj.util.module.wechat.basictoken.LocationWechatTokenManager;
import com.iteaj.util.module.wechat.jsapi.JsApiTicketLocationManager;
import com.iteaj.util.module.xml.Jaxb2Adapter;
import com.iteaj.util.module.xml.XmlAdapter;

public class UtilsFactory {
    private static Object lock = new Object();
    private static XmlAdapter defaultXmlAdapter = new Jaxb2Adapter();
    private static JsonAdapter defaultJsonAdapter;
    private static HttpAdapter defaultHttpAdapter;
    private static WechatTokenManager wechatTokenManager;
    private static TokenManager wechatJsTicketManager;
    private static SSLContextManager defaultSslManager;
    private static HttpRequestConfig defaultRequestConfig;
    private static AuthorizeStorageManager defaultStorageManager;

    public static XmlAdapter getDefaultXmlAdapter() {
        return defaultXmlAdapter;
    }

    public static void setDefaultXmlAdapter(XmlAdapter defaultXmlAdapter) {
        UtilsFactory.defaultXmlAdapter = defaultXmlAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpAdapter getDefaultHttpAdapter() {
        if (null != defaultHttpAdapter) {
            return defaultHttpAdapter;
        }
        Object object = lock;
        synchronized (object) {
            if (null != defaultHttpAdapter) {
                return defaultHttpAdapter;
            }
            try {
                defaultHttpAdapter = HttpClientAdapter.instance();
            }
            catch (Throwable e) {
                defaultHttpAdapter = new JdkHttpAdapter();
            }
            return defaultHttpAdapter;
        }
    }

    public static void setDefaultHttpAdapter(HttpAdapter defaultHttpAdapter) {
        if (UtilsFactory.defaultHttpAdapter == null) {
            UtilsFactory.defaultHttpAdapter = defaultHttpAdapter;
        }
    }

    public static AuthorizeStorageManager getDefaultStorageManager() {
        return defaultStorageManager;
    }

    public static void setDefaultStorageManager(AuthorizeStorageManager defaultStorageManager) {
        if (defaultStorageManager.getClass() != MapStorageManager.class) {
            UtilsFactory.defaultStorageManager = defaultStorageManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonAdapter getDefaultJsonAdapter() {
        if (defaultJsonAdapter != null) {
            return defaultJsonAdapter;
        }
        Object object = lock;
        synchronized (object) {
            if (defaultJsonAdapter != null) {
                return defaultJsonAdapter;
            }
            try {
                defaultJsonAdapter = new JacksonAdapter(new ObjectMapper());
            }
            catch (Throwable e) {
                defaultJsonAdapter = new FastJsonAdapter();
            }
            if (defaultJsonAdapter == null) {
                throw new UtilsException("\u65e0\u4efb\u4f55Json\u7684\u5b9e\u73b0\u4f9d\u8d56(Jackson\u3001FastJson)", UtilsType.JSON);
            }
            return defaultJsonAdapter;
        }
    }

    public static void setDefaultJsonAdapter(JsonAdapter defaultJsonAdapter) {
        UtilsFactory.defaultJsonAdapter = defaultJsonAdapter;
    }

    public static HttpRequestConfig getDefaultRequestConfig() {
        if (defaultRequestConfig == null) {
            return HttpRequestConfig.getDefault();
        }
        return defaultRequestConfig;
    }

    public static void setDefaultRequestConfig(HttpRequestConfig defaultRequestConfig) {
        UtilsFactory.defaultRequestConfig = defaultRequestConfig;
    }

    public static SSLContextManager getDefaultSslManager() {
        return defaultSslManager;
    }

    public static void setDefaultSslManager(SSLContextManager defaultSslManager) {
        UtilsFactory.defaultSslManager = defaultSslManager;
    }

    public static WechatTokenManager getWechatTokenManager() {
        return wechatTokenManager;
    }

    public static void setWechatTokenManager(WechatTokenManager wechatTokenManager) {
        UtilsFactory.wechatTokenManager = wechatTokenManager;
    }

    public static TokenManager getWechatJsTicketManager() {
        return wechatJsTicketManager;
    }

    public static void setWechatJsTicketManager(TokenManager wechatJsTicketManager) {
        UtilsFactory.wechatJsTicketManager = wechatJsTicketManager;
    }

    static {
        defaultSslManager = new SSLContextManager();
        defaultStorageManager = new MapStorageManager();
        wechatTokenManager = LocationWechatTokenManager.instance();
        defaultRequestConfig = HttpRequestConfig.getDefault();
        wechatJsTicketManager = JsApiTicketLocationManager.instance();
    }
}

