/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.UserAgent;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebUtils {
    public static String getCookie(HttpServletRequest request, String name) {
        Object[] cookies = request.getCookies();
        if (CommonUtils.isNotEmpty(cookies)) {
            for (Object item : cookies) {
                if (!item.getName().equals(name)) continue;
                return item.getValue();
            }
            return null;
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        WebUtils.addCookie(response, name, value, "/", -1);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String uri, int maxAge) {
        WebUtils.addCookie(response, name, value, uri, maxAge, false, null, false);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String uri, int maxAge, boolean httpOnly, String domain, boolean secure) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(uri);
        cookie.setMaxAge(maxAge);
        if (CommonUtils.isNotBlank(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(secure);
        cookie.setHttpOnly(httpOnly);
        response.addCookie(cookie);
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("user-agent");
    }

    public static boolean containAgent(HttpServletRequest request, String agentStr) {
        return WebUtils.getUserAgent(request).contains(agentStr);
    }

    public static UserAgent getAgent(HttpServletRequest request) {
        if (WebUtils.isAlipay(request)) {
            return UserAgent.Alipay;
        }
        if (WebUtils.isWechat(request)) {
            return UserAgent.Wechat;
        }
        return UserAgent.Other;
    }

    public static boolean isAlipay(HttpServletRequest request) {
        return WebUtils.containAgent(request, "Alipay");
    }

    public static boolean isWechat(HttpServletRequest request) {
        return WebUtils.containAgent(request, "MicroMessenger");
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException("\u53d1\u9001\u91cd\u5b9a\u5411\u5931\u8d25", e);
        }
    }
}

