/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class SpringWebUtils
implements ApplicationContextAware {
    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpSession getSession() {
        return SpringWebUtils.getRequest().getSession();
    }

    public static <T> T getRequestAttr(String name) {
        return (T)SpringWebUtils.getRequest().getAttribute(name);
    }

    public static <T> T getSessionAttr(String name) {
        return (T)SpringWebUtils.getSession().getAttribute(name);
    }

    public static <T> T getContextAttr(String name) {
        return (T)SpringWebUtils.getSession().getServletContext().getAttribute(name);
    }

    public static void setRequestAttr(String name, Object val) {
        SpringWebUtils.getRequest().setAttribute(name, val);
    }

    public static void setSessionAttr(String name, Object val) {
        SpringWebUtils.getSession().setAttribute(name, val);
    }

    public static void setContextAttr(String name, Object val) {
        SpringWebUtils.getSession().getServletContext().setAttribute(name, val);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!(applicationContext instanceof WebApplicationContext)) {
            throw new ApplicationContextException(this.getClass().getSimpleName() + "\u5fc5\u987b\u5728Web\u9879\u76ee\u4e2d\u6ce8\u5165\u4f7f\u7528");
        }
    }
}

