/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.DigestUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.wechat.pay.WxcPayAbstract;
import com.iteaj.util.module.wechat.pay.WxpPayAbstract;
import com.iteaj.util.module.wechat.pay.unified.WxaUnifiedOrder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaySignUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"PaySignLogger");

    public static void invokeWechatUnifiedOrderSign(WxpPayAbstract apiParam) {
        Optional.ofNullable(apiParam).map(Object::getClass).map(aClass -> CommonUtils.mergeArray(aClass.getFields(), aClass.getDeclaredFields())).ifPresent(fields -> {
            try {
                TreeMap<String, String> sort = new TreeMap<String, String>();
                for (Field item2 : fields) {
                    item2.setAccessible(true);
                    Object s = item2.get(apiParam);
                    if (null == s) continue;
                    sort.put(item2.getName(), s.toString());
                }
                StringBuilder sb = new StringBuilder();
                sort.entrySet().forEach(item -> sb.append((String)item.getKey()).append('=').append((String)item.getValue()).append('&'));
                WxcPayAbstract apiConfig = apiParam.getApiConfig();
                if (apiConfig == null || CommonUtils.isBlank(apiConfig.getKey())) {
                    throw new UtilsException("\u672a\u8bbe\u7f6e\u5fae\u4fe1\u652f\u4ed8\u5bc6\u94a5\uff1akey", UtilsType.WECHAT);
                }
                String sign = sb.append("key=").append(apiConfig.getKey()).toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("type\uff1a\u5fae\u4fe1\u652f\u4ed8 - action\uff1a\u652f\u4ed8\u7b7e\u540d - content\uff1a{}", (Object)sign);
                }
                String md5Hex = DigestUtils.md5Hex(sign.getBytes("UTF-8"));
                apiParam.setSign(md5Hex.toUpperCase());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
    }

    public static void invokeBrandWCPayRequestSign(WxaUnifiedOrder.WxrUnifiedOrderReSign orderReSign) {
        Optional.ofNullable(orderReSign).ifPresent(item -> {
            StringBuilder sb = new StringBuilder();
            sb.append("appId=").append(orderReSign.getAppId()).append("&nonceStr=").append(orderReSign.getNonceStr()).append("&package=").append(orderReSign.getPackage()).append("&signType=").append((Object)orderReSign.getSignType()).append("&timeStamp=").append(orderReSign.getTimeStamp()).append("&key=").append(orderReSign.getUnifiedConfig().getKey());
            String signStr = sb.toString();
            logger.info("type\uff1a\u5fae\u4fe1\u652f\u4ed8 - action\uff1a\u652f\u4ed8\u7b7e\u540d({}) - content\uff1a{}", (Object)orderReSign.getSignType(), (Object)signStr);
            String md5Hex = DigestUtils.md5Hex(signStr.getBytes());
            orderReSign.setPaySign(md5Hex.toUpperCase());
        });
    }
}

