/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util;

import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class CommonUtils {
    private static int EOF = -1;
    private static long GB = 0x40000000L;

    public static boolean isNotBlank(String param) {
        if (param == null) {
            return false;
        }
        return param.trim().length() > 0;
    }

    public static boolean isNotEmpty(Collection<?> params) {
        return null != params && params.size() > 0;
    }

    public static boolean isNotEmpty(Object[] params) {
        return null != params && params.length > 0;
    }

    public static Collection merge(Collection desc, Collection ori) {
        boolean descNotEmpty = CommonUtils.isNotEmpty(desc);
        boolean oriNotEmpty = CommonUtils.isNotEmpty(ori);
        if (!descNotEmpty) {
            throw new UtilsException("\u5408\u5e76\u96c6\u5408\u7684\u65f6\u5019\u76ee\u6807\u5bf9\u8c61\u5fc5\u987b\u5b58\u5728", UtilsType.Common);
        }
        if (descNotEmpty && !oriNotEmpty) {
            return desc;
        }
        desc.addAll(ori);
        return desc;
    }

    public static String fileName(String path) {
        if (!CommonUtils.isNotBlank(path)) {
            return "";
        }
        String s = String.format("\\%s", File.separator);
        String[] split = path.split(s);
        return split[split.length - 1];
    }

    public static String suffix(String name) {
        int lastIndexOf = name.lastIndexOf(".");
        if (EOF != lastIndexOf) {
            return name.substring(lastIndexOf);
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public static byte[] read(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] read(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(File file, OutputStream output) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            CommonUtils.copyStream(input, output, new byte[1024]);
        }
    }

    public static void write(byte[] bytes, OutputStream output) throws IOException {
        output.write(bytes);
    }

    protected static long copyStream(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int t;
        long count = 0L;
        while (-1 != (t = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, t);
            count += (long)t;
        }
        return count;
    }

    public static boolean isNotEmpty(byte[] bytes) {
        return null != bytes && bytes.length > 0;
    }

    public static boolean isNotEmpty(Map fields) {
        return null != fields && fields.size() > 0;
    }

    public static String concat(Collection<String> values, String separator) {
        if (!CommonUtils.isNotEmpty(values)) {
            return null;
        }
        if (!CommonUtils.isNotBlank(separator)) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder();
        for (String item : values) {
            sb.append(item).append(separator);
        }
        return sb.substring(0, sb.length() - separator.length());
    }

    public static <T> Collection<T> mergeArray(T[] ... list) {
        if (null == list) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> mergeList = new ArrayList<T>();
        for (T[] item : list) {
            mergeList.addAll(Arrays.asList(item));
        }
        return mergeList;
    }

    public static boolean isBlank(String str) {
        return null == str || str.trim().length() == 0;
    }

    public static Type[] getParameterizedType(Object obj) {
        Type superclass = obj.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            return ((ParameterizedType)superclass).getActualTypeArguments();
        }
        return null;
    }

    public static boolean isNotEmpty(boolean[] booleans) {
        return booleans != null && booleans.length > 0;
    }
}

