/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.serial.SerialClient;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.serial.SerialEventProtocolHandle;
import com.iteaj.iot.serial.SerialPortDelimiterListener;
import com.iteaj.iot.serial.SerialPortPacketProtocolListener;
import com.iteaj.iot.serial.SerialProtocolException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class SerialPortCreator {
    public static Optional<SerialClient> get(String com) {
        return Optional.ofNullable(SerialPortCreator.getIotClient(new SerialConnectProperties(com)));
    }

    public static List<SerialPort> available() {
        return Arrays.asList(SerialPort.getCommPorts());
    }

    public static boolean isOpen(String com) {
        Optional<SerialClient> client = SerialPortCreator.get(com);
        return client.isPresent() ? client.get().isOpen() : false;
    }

    public static SerialClient opened(String com) {
        SerialClient serialClient = SerialPortCreator.getIotClient(new SerialConnectProperties(com));
        if (serialClient == null) {
            throw new SerialProtocolException("\u4e32\u53e3\u4e0d\u5b58\u5728[" + com + "]");
        }
        if (!serialClient.isOpen()) {
            serialClient.connect((Consumer)null, 100L);
        }
        return serialClient;
    }

    public static boolean close(String com) {
        SerialClient client = SerialComponent.instance().getClient(com);
        if (client != null) {
            return client.close();
        }
        return false;
    }

    public static synchronized SerialClient open(SerialConnectProperties properties) {
        SerialClient serialClient = SerialPortCreator.getIotClient(properties);
        if (serialClient == null) {
            return SerialComponent.instance().createNewClientAndConnect(properties);
        }
        if (!serialClient.isOpen() && !((Boolean)serialClient.connect((Consumer)null, 100L)).booleanValue()) {
            throw new SerialProtocolException("\u6253\u5f00\u4e32\u53e3\u5931\u8d25[" + (Object)((Object)properties) + "]");
        }
        return serialClient;
    }

    protected static synchronized SerialClient open(SerialConnectProperties properties, SerialPortDataListener listener) {
        SerialClient serialClient = SerialPortCreator.getIotClient(properties);
        if (serialClient == null) {
            return SerialComponent.instance().createNewClientAndConnect(properties, listener);
        }
        if (!serialClient.isOpen()) {
            if (serialClient.getListener() != null) {
                serialClient.removeDataListener();
                serialClient.addDataListener(listener);
            }
            if (!((Boolean)serialClient.connect((Consumer)null, 100L)).booleanValue()) {
                throw new SerialProtocolException("\u6253\u5f00\u4e32\u53e3\u5931\u8d25[" + (Object)((Object)properties) + "]");
            }
        }
        return serialClient;
    }

    public static SerialClient openByAsync(SerialConnectProperties connectProperties, int packetSize, SerialEventProtocolHandle handle) {
        return SerialPortCreator.open(connectProperties, (SerialPortDataListener)new SerialPortPacketProtocolListener(packetSize, connectProperties, handle));
    }

    public static SerialClient openByAsync(SerialConnectProperties connectProperties, byte[] delimiter, SerialEventProtocolHandle handle) {
        return SerialPortCreator.openByAsync(connectProperties, delimiter, handle, true);
    }

    public static SerialClient openByAsync(SerialConnectProperties connectProperties, byte[] delimiter, SerialEventProtocolHandle handle, boolean endOfMessage) {
        return SerialPortCreator.open(connectProperties, (SerialPortDataListener)new SerialPortDelimiterListener(delimiter, connectProperties, handle, endOfMessage));
    }

    protected static SerialClient getIotClient(SerialConnectProperties properties) throws ProtocolException {
        return SerialComponent.instance().getClient((Object)properties);
    }
}

