/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.fazecast.jSerialComm.SerialPortEvent;
import com.iteaj.iot.AbstractProtocol;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.serial.SerialMessage;
import com.iteaj.iot.serial.SerialProtocolType;

public class SerialEventProtocol
extends AbstractProtocol<SerialMessage> {
    private Exception cause;
    private SerialPortEvent event;
    private SerialConnectProperties connectProperties;

    protected SerialEventProtocol(Object event, SerialConnectProperties connectProperties) {
        if (event instanceof SerialPortEvent) {
            this.event = (SerialPortEvent)event;
        } else {
            this.cause = (Exception)event;
        }
        this.connectProperties = connectProperties;
    }

    public AbstractProtocol buildRequestMessage() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
    }

    public AbstractProtocol buildResponseMessage() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
    }

    public int write(byte[] msg) {
        return this.event.getSerialPort().writeBytes(msg, (long)msg.length);
    }

    public int write(byte[] msg, int offset) {
        return this.event.getSerialPort().writeBytes(msg, (long)(msg.length - offset), (long)offset);
    }

    public SerialProtocolType protocolType() {
        return SerialProtocolType.Event;
    }

    public Exception getCause() {
        return this.cause;
    }

    public SerialPortEvent getEvent() {
        return this.event;
    }

    protected SerialEventProtocol setEvent(SerialPortEvent event) {
        this.event = event;
        return this;
    }

    public SerialConnectProperties getConnectProperties() {
        return this.connectProperties;
    }
}

