/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.iteaj.iot.ConcurrentStorageManager;
import com.iteaj.iot.IotProtocolFactory;
import com.iteaj.iot.client.ClientComponent;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.IotClient;
import com.iteaj.iot.codec.filter.Interceptor;
import com.iteaj.iot.serial.SerialClient;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.serial.SerialEventProtocolHandle;
import com.iteaj.iot.serial.SerialMessage;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialComponent
extends ConcurrentStorageManager<String, IotClient>
implements ClientComponent<SerialMessage> {
    private static final String NAME = "\u4e32\u53e3\u7ec4\u4ef6";
    private static final String DESC = "\u652f\u6301windows\u3001mac\u3001linux\u7b49\u4e32\u53e3\u901a\u8baf";
    private boolean start;
    private long startTime;
    private static SerialComponent serialComponent;
    private SerialConnectProperties connectProperties;
    private SerialEventProtocolHandle protocolHandle;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected SerialComponent() {
    }

    protected SerialComponent(SerialConnectProperties connectProperties) {
        this.connectProperties = connectProperties;
    }

    public static SerialComponent instance() {
        return SerialComponent.instance(null);
    }

    public static SerialComponent instance(SerialConnectProperties connectProperties) {
        if (serialComponent == null) {
            serialComponent = new SerialComponent(connectProperties);
        }
        return serialComponent;
    }

    public String getName() {
        return NAME;
    }

    public String getDesc() {
        return DESC;
    }

    public boolean isStart() {
        return this.start;
    }

    public long startTime() {
        return this.startTime;
    }

    public void start(Object config) {
        this.startTime = System.currentTimeMillis();
        if (this.getConfig() != null) {
            SerialClient newClient = this.createNewClient(this.getConfig());
            newClient.init(null);
            newClient.connect((Consumer)null, 0L);
        }
    }

    public synchronized void close() {
        try {
            if (this.isStart()) {
                this.clients().forEach(item -> item.close());
            }
        }
        finally {
            this.start = false;
        }
    }

    public IotProtocolFactory protocolFactory() {
        return null;
    }

    public SerialConnectProperties getConfig() {
        return this.connectProperties;
    }

    public SerialClient getClient() {
        if (this.getConfig() != null) {
            return this.getClient((Object)this.getConfig());
        }
        return null;
    }

    public SerialPort[] available() {
        return SerialPort.getCommPorts();
    }

    public synchronized void addClient(Object clientKey, IotClient value) {
        if (!this.isExists(clientKey.toString())) {
            this.add(clientKey.toString(), value);
        }
    }

    public SerialClient getClient(Object clientKey) {
        return (SerialClient)this.get(clientKey.toString());
    }

    public SerialClient removeClient(Object clientKey) {
        return (SerialClient)this.remove(clientKey.toString());
    }

    public List<IotClient> clients() {
        return this.getMapper().values().stream().collect(Collectors.toList());
    }

    public SerialClient createNewClient(ClientConnectProperties config) {
        SerialClient client = this.getClient(config);
        if (client == null) {
            client = new SerialClient(this, (SerialConnectProperties)config);
        }
        return client;
    }

    public SerialClient createNewClientAndConnect(ClientConnectProperties config) {
        SerialClient client = this.getClient(config);
        if (client == null) {
            client = new SerialClient(this, (SerialConnectProperties)config);
        }
        client.init(null);
        client.connect(null, 100L);
        return client;
    }

    public SerialClient createNewClientAndConnect(ClientConnectProperties config, SerialPortDataListener listener) {
        SerialClient client = this.getClient(config);
        if (client == null) {
            client = new SerialClient(this, (SerialConnectProperties)config);
        }
        client.init(listener);
        client.connect(null, 100L);
        return client;
    }

    public SerialEventProtocolHandle getProtocolHandle() {
        return this.protocolHandle;
    }

    public SerialComponent setProtocolHandle(SerialEventProtocolHandle protocolHandle) {
        this.protocolHandle = protocolHandle;
        return this;
    }

    public void finished() {
        super.finished();
        if (this.logger.isInfoEnabled()) {
            if (this.getConfig() == null) {
                this.logger.info("\u542f\u7528\u4e32\u53e3\u7ec4\u4ef6\u6210\u529f - \u7b80\u4ecb: {}", (Object)this.getDesc());
            } else {
                this.logger.info("\u542f\u7528\u4e32\u53e3\u7ec4\u4ef6\u6210\u529f - \u9ed8\u8ba4\u4e32\u53e3: {} - \u7b80\u4ecb: {}", (Object)this.getConfig(), (Object)this.getDesc());
            }
        }
    }

    public Interceptor getInterceptor() {
        return null;
    }
}

