/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.iteaj.iot.client.ClientComponent;
import com.iteaj.iot.client.IotClient;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.serial.SerialPortDelimiterListener;
import com.iteaj.iot.serial.SerialPortPacketProtocolListener;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialClient
implements IotClient {
    private SerialPort serialPort;
    private SerialPortDataListener listener;
    private SerialComponent serialComponent;
    private SerialConnectProperties connectProperties;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SerialClient(SerialComponent serialComponent, SerialConnectProperties connectProperties) {
        this.serialComponent = serialComponent;
        this.connectProperties = connectProperties;
    }

    public boolean isOpen() {
        return this.serialPort.isOpen();
    }

    public int getPort() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
    }

    public void init(Object arg) {
        this.serialPort = SerialPort.getCommPort((String)this.connectProperties.connectKey());
        this.serialPort.setComPortParameters(this.connectProperties.getBaudRate(), this.connectProperties.getDataBits(), this.connectProperties.getStopBits(), this.connectProperties.getParity(), this.connectProperties.isUseRS485Mode());
        if (arg instanceof SerialPortDataListener) {
            this.addDataListener((SerialPortDataListener)arg);
        }
        int timeoutMode = 272;
        this.serialPort.setComPortTimeouts(timeoutMode, (int)this.connectProperties.getReaderIdleTime() * 1000, (int)this.connectProperties.getWriterIdleTime() * 1000);
    }

    public int bytesAvailable() {
        return this.serialPort.bytesAvailable();
    }

    public int bytesAwaitingWrite() {
        return this.serialPort.bytesAwaitingWrite();
    }

    public int read(byte[] msg) {
        return this.serialPort.readBytes(msg, (long)msg.length);
    }

    public int read(byte[] msg, int offset) {
        return this.serialPort.readBytes(msg, (long)msg.length, (long)offset);
    }

    public int write(byte[] msg) {
        return this.serialPort.writeBytes(msg, (long)msg.length);
    }

    public int write(byte[] msg, int offset) {
        return this.serialPort.writeBytes(msg, (long)(msg.length - offset), (long)offset);
    }

    public Boolean connect(Consumer<?> consumer, long timeout) {
        boolean openPort = this.serialPort.openPort((int)timeout, this.connectProperties.getSendDeviceQueueSize(), this.connectProperties.getReceiveDeviceQueueSize());
        if (openPort) {
            this.getClientComponent().addClient((Object)this.connectProperties, (IotClient)this);
        }
        if (consumer != null) {
            consumer.accept(openPort);
        } else {
            String style = "\u540c\u6b65";
            if (this.listener instanceof SerialPortDelimiterListener) {
                style = "\u5f02\u6b65(\u5206\u9694\u7b26)";
            } else if (this.listener instanceof SerialPortPacketProtocolListener) {
                style = "\u5f02\u6b65(\u56fa\u5b9a\u957f\u5ea6)";
            }
            if (openPort) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\u4e32\u53e3\u5ba2\u6237\u7aef({}) \u6253\u5f00\u6210\u529f - \u65b9\u5f0f\uff1a{}", (Object)this.connectProperties, (Object)style);
                }
            } else {
                this.logger.error("\u4e32\u53e3\u5ba2\u6237\u7aef({}) \u6253\u5f00\u5931\u8d25 - \u65b9\u5f0f\uff1a{}", (Object)this.connectProperties, (Object)style);
            }
        }
        return openPort;
    }

    public Boolean disconnect() {
        boolean status;
        boolean bl = status = this.serialPort.isOpen() ? this.serialPort.closePort() : true;
        if (status) {
            this.logger.info("\u4e32\u53e3\u5ba2\u6237\u7aef({}) \u5173\u95ed\u6210\u529f", (Object)this.connectProperties);
        } else {
            this.logger.error("\u4e32\u53e3\u5ba2\u6237\u7aef({}) \u5173\u95ed\u5931\u8d25", (Object)this.connectProperties);
        }
        return status;
    }

    public synchronized boolean addDataListener(SerialPortDataListener dataListener) {
        this.listener = dataListener;
        return this.getSerialPort().addDataListener(dataListener);
    }

    public synchronized void removeDataListener() {
        if (this.getListener() != null) {
            this.listener = null;
            this.getSerialPort().removeDataListener();
        }
    }

    public Boolean close() {
        if (this.disconnect().booleanValue()) {
            this.getClientComponent().removeClient((Object)this.getConfig());
            return true;
        }
        return false;
    }

    public ClientComponent getClientComponent() {
        return this.serialComponent;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public SerialConnectProperties getConfig() {
        return this.connectProperties;
    }

    public SerialPortDataListener getListener() {
        return this.listener;
    }
}

