/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log.utils;

public final class SofaClassLoaderUtil {
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getCallerClassLoader() {
        try {
            String callerClassName = Thread.currentThread().getStackTrace()[3].getClassName();
            try {
                return Class.forName(callerClassName).getClassLoader();
            }
            catch (ClassNotFoundException e) {
                return Class.forName(callerClassName, true, SofaClassLoaderUtil.getContextClassLoader()).getClassLoader();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to get caller classloader ", t);
        }
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private SofaClassLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

