/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log.space;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SpaceId {
    static Map<String, SpaceId> GLOBAL_SPACE_ID_CACHE = new ConcurrentHashMap<String, SpaceId>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private final String spaceName;

    public SpaceId(String spaceName) {
        Objects.requireNonNull(spaceName);
        this.spaceName = spaceName;
    }

    public static SpaceId withSpaceName(String spaceName) {
        return GLOBAL_SPACE_ID_CACHE.computeIfAbsent(spaceName, SpaceId::new);
    }

    public SpaceId withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceId spaceId = (SpaceId)o;
        if (!this.tags.equals(spaceId.tags)) {
            return false;
        }
        return Objects.equals(this.spaceName, spaceId.spaceName);
    }

    public int hashCode() {
        int result = this.tags.hashCode();
        result = 31 * result + this.spaceName.hashCode();
        return result;
    }

    public String toString() {
        if (this.tags.size() == 0) {
            return this.spaceName;
        }
        StringBuilder sb = new StringBuilder(this.spaceName);
        sb.append("[");
        Iterator<Map.Entry<String, String>> iterator = this.tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

