/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log.proxy;

import com.iohao.game.common.log.LoggerSpaceManager;
import com.iohao.game.common.log.proxy.TemporaryLoggerFactory;
import com.iohao.game.common.log.space.SpaceId;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryLoggerFactoryPool {
    static final ConcurrentHashMap<SpaceIdWithClassloader, TemporaryLoggerFactory> temporaryILoggerFactoryMap = new ConcurrentHashMap();
    static final Logger logger = LoggerFactory.getLogger(LoggerSpaceManager.class);

    public static TemporaryLoggerFactory get(String space, ClassLoader spaceClassLoader) {
        return TemporaryLoggerFactoryPool.get(new SpaceId(space), spaceClassLoader);
    }

    public static TemporaryLoggerFactory get(SpaceId spaceId, ClassLoader spaceClassLoader) {
        TemporaryLoggerFactory temporaryLoggerFactory = temporaryILoggerFactoryMap.get(new SpaceIdWithClassloader(spaceId, spaceClassLoader));
        if (temporaryLoggerFactory != null) {
            return temporaryLoggerFactory;
        }
        temporaryLoggerFactory = new TemporaryLoggerFactory(spaceId, spaceClassLoader, logger);
        SpaceIdWithClassloader spaceIdWithClassloader = new SpaceIdWithClassloader(spaceId, spaceClassLoader);
        temporaryILoggerFactoryMap.putIfAbsent(spaceIdWithClassloader, temporaryLoggerFactory);
        return temporaryLoggerFactory;
    }

    private static class SpaceIdWithClassloader {
        private SpaceId spaceId;
        private ClassLoader classLoader;

        public SpaceIdWithClassloader() {
        }

        public SpaceIdWithClassloader(SpaceId spaceId, ClassLoader classLoader) {
            this.spaceId = spaceId;
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpaceIdWithClassloader that = (SpaceIdWithClassloader)o;
            if (!Objects.equals(this.spaceId, that.spaceId)) {
                return false;
            }
            return Objects.equals(this.classLoader, that.classLoader);
        }

        public int hashCode() {
            int result = this.spaceId != null ? this.spaceId.hashCode() : 0;
            result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
            return result;
        }

        public SpaceId getSpaceId() {
            return this.spaceId;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setSpaceId(SpaceId spaceId) {
            this.spaceId = spaceId;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

