/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log.proxy;

import com.iohao.game.common.log.MultiAppLoggerSpaceManager;
import com.iohao.game.common.log.factory.AbstractLoggerSpaceFactory;
import com.iohao.game.common.log.proxy.LoggerProxy;
import com.iohao.game.common.log.space.SpaceId;
import com.iohao.game.common.log.utils.SofaAssertUtil;
import org.slf4j.Logger;

public class TemporaryLoggerFactory
extends AbstractLoggerSpaceFactory {
    private final String space;
    private final ClassLoader spaceClassLoader;
    private final Logger tempLogger;
    private final SpaceId spaceId;
    private final LoggerSelector loggerSelector;

    public TemporaryLoggerFactory(String space, ClassLoader spaceClassLoader, Logger tempLogger) {
        this(new SpaceId(space), spaceClassLoader, tempLogger);
    }

    public TemporaryLoggerFactory(SpaceId spaceId, ClassLoader spaceClassLoader, Logger tempLogger) {
        super("temp");
        SofaAssertUtil.notNull(spaceId);
        SofaAssertUtil.notNull(spaceClassLoader);
        SofaAssertUtil.notNull(tempLogger);
        this.space = spaceId.getSpaceName();
        this.spaceId = spaceId;
        this.spaceClassLoader = spaceClassLoader;
        this.tempLogger = tempLogger;
        this.loggerSelector = this.buildLoggerSelector();
        SofaAssertUtil.notNull(this.loggerSelector);
    }

    protected LoggerSelector buildLoggerSelector() {
        return new LoggerSelector();
    }

    public Logger getLogger(String name) {
        return new LoggerProxy(this.loggerSelector, name);
    }

    public class LoggerSelector {
        private boolean warned = false;

        public Logger select(String name) {
            if (!this.isSpaceInitialized()) {
                if (!this.warned) {
                    TemporaryLoggerFactory.this.tempLogger.warn(">>> Logger Space:{} has not be initialized! Use app logger temporary\uff01", (Object)TemporaryLoggerFactory.this.space);
                    this.warned = true;
                }
                return TemporaryLoggerFactory.this.tempLogger;
            }
            if (this.warned) {
                TemporaryLoggerFactory.this.tempLogger.info("<<< Logger Space:{} was initialized! Use this space logger.", (Object)TemporaryLoggerFactory.this.space);
                this.warned = false;
            }
            return this.getLoggerBySpace(name);
        }

        protected Logger getLoggerBySpace(String name) {
            return MultiAppLoggerSpaceManager.getLoggerBySpace(name, TemporaryLoggerFactory.this.spaceId, TemporaryLoggerFactory.this.spaceClassLoader);
        }

        protected boolean isSpaceInitialized() {
            return MultiAppLoggerSpaceManager.isSpaceInitialized(TemporaryLoggerFactory.this.spaceId);
        }
    }
}

