/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log;

import com.iohao.game.common.log.Constants;
import com.iohao.game.common.log.LogSpace;
import com.iohao.game.common.log.adapter.level.AdapterLevel;
import com.iohao.game.common.log.env.LogEnvUtils;
import com.iohao.game.common.log.factory.AbstractLoggerSpaceFactory;
import com.iohao.game.common.log.factory.LoggerSpaceFactory4CommonsLoggingBuilder;
import com.iohao.game.common.log.factory.LoggerSpaceFactory4Log4j2Builder;
import com.iohao.game.common.log.factory.LoggerSpaceFactory4Log4jBuilder;
import com.iohao.game.common.log.factory.LoggerSpaceFactory4LogbackBuilder;
import com.iohao.game.common.log.proxy.TemporaryLoggerFactoryPool;
import com.iohao.game.common.log.space.SpaceId;
import com.iohao.game.common.log.utils.SofaClassLoaderUtil;
import com.iohao.game.common.log.utils.SofaReportUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class MultiAppLoggerSpaceManager {
    static final AbstractLoggerSpaceFactory NOP_LOGGER_FACTORY = new AbstractLoggerSpaceFactory("nop"){

        public Logger getLogger(String name) {
            return Constants.DEFAULT_LOG;
        }
    };
    static final Map<SpaceId, LogSpace> LOG_FACTORY_MAP = new ConcurrentHashMap<SpaceId, LogSpace>();

    public static void init(String spaceName, Map<String, String> props) {
        MultiAppLoggerSpaceManager.init(new SpaceId(spaceName), props, SofaClassLoaderUtil.getCallerClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(SpaceId spaceId, Map<String, String> props, ClassLoader spaceClassloader) {
        if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            SofaReportUtil.reportWarn("Logger space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
            return;
        }
        SpaceId spaceId2 = spaceId;
        synchronized (spaceId2) {
            if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
                SofaReportUtil.reportWarn("Logger space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
                return;
            }
            MultiAppLoggerSpaceManager.doInit(spaceId, props, spaceClassloader);
        }
        SofaReportUtil.reportInfo("Logger Space: \"" + spaceId.toString() + "\" init ok.");
    }

    static void doInit(String spaceName, Map<String, String> props, ClassLoader spaceClassloader) {
        MultiAppLoggerSpaceManager.doInit(SpaceId.withSpaceName(spaceName), props, spaceClassloader);
    }

    static void doInit(SpaceId spaceId, Map<String, String> props, ClassLoader spaceClassloader) {
        LogSpace logSpace = new LogSpace(props, spaceClassloader);
        LOG_FACTORY_MAP.putIfAbsent(spaceId, logSpace);
    }

    public static Logger getLoggerBySpace(String name, String spaceName) {
        ClassLoader callerClassLoader = SofaClassLoaderUtil.getCallerClassLoader();
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), callerClassLoader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId) {
        ClassLoader callerClassLoader = SofaClassLoaderUtil.getCallerClassLoader();
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, callerClassLoader);
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, ClassLoader spaceClassloader) {
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, spaceClassloader);
        return abstractLoggerSpaceFactory.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractLoggerSpaceFactory getILoggerFactoryBySpaceName(SpaceId spaceId, ClassLoader spaceClassloader) {
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            return TemporaryLoggerFactoryPool.get(spaceId, spaceClassloader);
        }
        AbstractLoggerSpaceFactory factory = NOP_LOGGER_FACTORY;
        LogSpace space = LOG_FACTORY_MAP.get(spaceId);
        if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
            LogSpace logSpace = space;
            synchronized (logSpace) {
                if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
                    factory = MultiAppLoggerSpaceManager.createILoggerFactory(spaceId, space, spaceClassloader);
                    space.setAbstractLoggerSpaceFactory(factory);
                }
            }
        } else {
            factory = LOG_FACTORY_MAP.get(spaceId).getAbstractLoggerSpaceFactory();
        }
        return factory;
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, new SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        ClassLoader callerClassLoader = SofaClassLoaderUtil.getCallerClassLoader();
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, callerClassLoader);
        try {
            abstractLoggerSpaceFactory.setLevel(loggerName, adapterLevel);
        }
        catch (Exception e) {
            SofaReportUtil.reportError("SetLoggerLevel Error : ", e);
        }
        return abstractLoggerSpaceFactory.getLogger(loggerName);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(new SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        if (spaceId == null) {
            return null;
        }
        LogSpace logSpace = LOG_FACTORY_MAP.get(spaceId);
        if (logSpace == null) {
            return null;
        }
        AbstractLoggerSpaceFactory oldFactory = logSpace.getAbstractLoggerSpaceFactory();
        LOG_FACTORY_MAP.remove(spaceId);
        SofaReportUtil.reportWarn("Log Space Name[" + spaceId.getSpaceName() + "] is Removed from Current Log Space Manager!");
        return oldFactory;
    }

    public static boolean isSpaceInitialized(String spaceName) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(new SpaceId(spaceName));
    }

    public static boolean isSpaceInitialized(SpaceId spaceId) {
        return LOG_FACTORY_MAP.containsKey(spaceId);
    }

    private static boolean isSpaceILoggerFactoryExisted(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId) && LOG_FACTORY_MAP.get(spaceId).getAbstractLoggerSpaceFactory() != null;
    }

    private static AbstractLoggerSpaceFactory createILoggerFactory(SpaceId spaceId, LogSpace logSpace, ClassLoader spaceClassloader) {
        if (Constants.SOFA_MIDDLEWARE_LOG_DISABLE) {
            SofaReportUtil.reportWarn("Sofa-Middleware-Log is disabled!  -Dsofa.middleware.log.disable=true");
            return NOP_LOGGER_FACTORY;
        }
        logSpace.putAll(LogEnvUtils.processGlobalSystemLogProperties());
        try {
            if (Constants.LOGBACK_MIDDLEWARE_LOG_DISABLE) {
                SofaReportUtil.reportWarn("Logback-Sofa-Middleware-Log is disabled! -Dlogback.middleware.log.disable=true");
            } else if (LogEnvUtils.isLogbackUsable(spaceClassloader)) {
                SofaReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Logback ]");
                LoggerSpaceFactory4LogbackBuilder loggerSpaceFactory4LogbackBuilder = new LoggerSpaceFactory4LogbackBuilder(spaceId, logSpace);
                return loggerSpaceFactory4LogbackBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J_MIDDLEWARE_LOG_DISABLE) {
                SofaReportUtil.reportWarn("Log4j-Sofa-Middleware-Log is disabled!  -Dlog4j.middleware.log.disable=true");
            } else if (LogEnvUtils.isLog4jUsable(spaceClassloader)) {
                SofaReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j ]");
                LoggerSpaceFactory4Log4jBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4Log4jBuilder(spaceId, logSpace);
                return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J2_MIDDLEWARE_LOG_DISABLE) {
                SofaReportUtil.reportWarn("Log4j2-Sofa-Middleware-Log is disabled!  -Dlog4j2.middleware.log.disable=true");
            } else if (LogEnvUtils.isLog4j2Usable(spaceClassloader)) {
                SofaReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j2 ]");
                LoggerSpaceFactory4Log4j2Builder loggerSpaceFactory4Log4j2Builder = new LoggerSpaceFactory4Log4j2Builder(spaceId, logSpace);
                return loggerSpaceFactory4Log4j2Builder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            if (Constants.LOG4J_COMMONS_LOGGING_MIDDLEWARE_LOG_DISABLE) {
                SofaReportUtil.reportWarn("Log4j-Sofa-Middleware-Log(commons-logging) is disabled!  -Dlog4j.commons.logging.middleware.log.disable=true");
            } else if (LogEnvUtils.isCommonsLoggingUsable(spaceClassloader)) {
                SofaReportUtil.reportDebug("Actual binding is of type [ " + spaceId.toString() + " Log4j (Adapter commons-logging to slf4j)]");
                LoggerSpaceFactory4CommonsLoggingBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4CommonsLoggingBuilder(spaceId, logSpace);
                return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
            }
            SofaReportUtil.reportWarn("[" + spaceId.toString() + "] No log util is usable, Default app logger will be used.");
        }
        catch (Throwable e) {
            SofaReportUtil.reportError("[" + spaceId.toString() + "] Build ILoggerFactory error! Default app logger will be used.", e);
        }
        return NOP_LOGGER_FACTORY;
    }
}

