/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log;

import com.iohao.game.common.log.MultiAppLoggerSpaceManager;
import com.iohao.game.common.log.adapter.level.AdapterLevel;
import com.iohao.game.common.log.space.SpaceId;
import com.iohao.game.common.log.utils.SofaClassLoaderUtil;
import java.util.Collections;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LoggerSpaceManager {
    public static Logger getLoggerBySpace(String name, String spaceName) {
        return LoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), Collections.emptyMap());
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceName, spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties) {
        ClassLoader callerClassLoader = SofaClassLoaderUtil.getCallerClassLoader();
        return LoggerSpaceManager.getLoggerBySpace(name, spaceId, properties, callerClassLoader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties, ClassLoader spaceClassloader) {
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            MultiAppLoggerSpaceManager.init(spaceId, properties, spaceClassloader);
        }
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, spaceClassloader);
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return LoggerSpaceManager.setLoggerLevel(loggerName, new SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, spaceId, adapterLevel);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return LoggerSpaceManager.removeILoggerFactoryBySpaceId(new SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(spaceId);
    }
}

