/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log;

import com.iohao.game.common.log.utils.SofaStringUtil;
import java.util.HashMap;
import java.util.Map;

public class LogLog {
    static final String DEBUG_PREFIX = "Sofa-Middleware-Log:DEBUG  ";
    static final String INFO_PREFIX = "Sofa-Middleware-Log:INFO ";
    static final String ERR_PREFIX = "Sofa-Middleware-Log:ERROR ";
    static final String WARN_PREFIX = "Sofa-Middleware-Log:WARN ";
    static final Map<String, Level> LEVELS = new HashMap<String, Level>();
    static volatile Level consoleLogLevel = Level.WARN;

    public static void setConsoleLevel(String level) {
        Level value = LEVELS.get(level.toUpperCase());
        if (!SofaStringUtil.isBlank(level) && value != null) {
            consoleLogLevel = value;
        }
    }

    public static void debug(String msg) {
        if (LogLog.isDebug()) {
            System.out.println(DEBUG_PREFIX + msg);
        }
    }

    public static void info(String msg) {
        if (LogLog.isInfo()) {
            System.out.println(INFO_PREFIX + msg);
        }
    }

    public static void warn(String msg) {
        if (LogLog.isWarn()) {
            System.err.println(WARN_PREFIX + msg);
        }
    }

    public static void warn(String msg, Throwable e) {
        if (LogLog.isWarn()) {
            System.err.println(WARN_PREFIX + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void error(String msg, Throwable throwable) {
        if (LogLog.isError()) {
            System.err.println(ERR_PREFIX + msg);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    private static boolean isDebug() {
        LogLog.setConsoleLevel(System.getProperty("sofa.middleware.log.internal.level", "WARN"));
        return consoleLogLevel.equals((Object)Level.DEBUG);
    }

    private static boolean isInfo() {
        return LogLog.isDebug() || consoleLogLevel.equals((Object)Level.INFO);
    }

    private static boolean isWarn() {
        return LogLog.isInfo() || consoleLogLevel.equals((Object)Level.WARN);
    }

    private static boolean isError() {
        return LogLog.isWarn() || consoleLogLevel.equals((Object)Level.ERROR);
    }

    static {
        LEVELS.put("DEBUG", Level.DEBUG);
        LEVELS.put("INFO", Level.INFO);
        LEVELS.put("WARN", Level.WARN);
        LEVELS.put("ERROR", Level.ERROR);
    }

    static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

