/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.log;

import com.iohao.game.common.log.utils.SofaStringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommonLoggingConfigurations {
    static Set<String> loggerConsoleWhiteSet;
    static Set<String> loggerConsolePrefixWhiteSet;
    static final Map<String, String> externalConfigurations;

    public static void loadExternalConfiguration(String key, String value) {
        if (SofaStringUtil.isNotEmpty(key) && SofaStringUtil.isNotEmpty(value)) {
            externalConfigurations.put(key, value);
        }
    }

    public static Map<String, String> getExternalConfigurations() {
        return externalConfigurations;
    }

    public static void setLoggerConsoleWhiteSet(Set<String> set) {
        loggerConsoleWhiteSet = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void appendConsoleLoggerName(String loggerName) {
        if (loggerConsoleWhiteSet == null) {
            Class<CommonLoggingConfigurations> clazz = CommonLoggingConfigurations.class;
            // MONITORENTER : com.iohao.game.common.log.CommonLoggingConfigurations.class
            if (loggerConsoleWhiteSet == null) {
                loggerConsoleWhiteSet = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        loggerConsoleWhiteSet.add(loggerName);
    }

    public static void setLoggerConsolePrefixWhiteSet(Set<String> loggerConsolePrefixWhiteSet) {
        CommonLoggingConfigurations.loggerConsolePrefixWhiteSet = loggerConsolePrefixWhiteSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void appendConsolePrefixWhiteLoggerName(String loggerName) {
        if (loggerConsolePrefixWhiteSet == null) {
            Class<CommonLoggingConfigurations> clazz = CommonLoggingConfigurations.class;
            // MONITORENTER : com.iohao.game.common.log.CommonLoggingConfigurations.class
            if (loggerConsolePrefixWhiteSet == null) {
                loggerConsolePrefixWhiteSet = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        loggerConsolePrefixWhiteSet.add(loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void addAllConsoleLogger(Set<String> set) {
        if (loggerConsoleWhiteSet == null) {
            Class<CommonLoggingConfigurations> clazz = CommonLoggingConfigurations.class;
            // MONITORENTER : com.iohao.game.common.log.CommonLoggingConfigurations.class
            if (loggerConsoleWhiteSet == null) {
                loggerConsoleWhiteSet = Collections.synchronizedSet(new HashSet());
            }
            // MONITOREXIT : clazz
        }
        if (set == null) return;
        loggerConsoleWhiteSet.addAll(set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldAttachConsoleAppender(String loggerName) {
        if (loggerConsoleWhiteSet == null && loggerConsolePrefixWhiteSet == null) {
            return false;
        }
        if (loggerConsoleWhiteSet != null && loggerConsoleWhiteSet.contains(loggerName)) {
            return true;
        }
        if (loggerConsolePrefixWhiteSet == null) return false;
        if (!loggerConsolePrefixWhiteSet.stream().anyMatch(loggerName::startsWith)) return false;
        return true;
    }

    static {
        externalConfigurations = new ConcurrentHashMap<String, String>();
    }
}

