/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.protobuf;

import com.iohao.game.common.kit.StrKit;
import com.iohao.game.widget.light.protobuf.ProtoJava;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtoJavaRegion {
    private String fileName;
    private String filePackage;
    private final Map<Class<?>, ProtoJava> protoJavaMap = new HashMap();
    private final List<ProtoJava> protoJavaList = new ArrayList<ProtoJava>();
    private final ProtoJavaRegionHead regionHead = new ProtoJavaRegionHead();

    public void addProtoJava(ProtoJava protoJava) {
        this.protoJavaList.add(protoJava);
        this.protoJavaMap.put(protoJava.getClazz(), protoJava);
    }

    public void addOtherProtoFile(ProtoJava protoJava) {
        String fileName = protoJava.getFileName();
        this.regionHead.fileNameSet.add(fileName);
    }

    public String toProtoFile() {
        this.regionHead.filePackage = this.filePackage;
        String protoHead = this.regionHead.toProtoHead();
        StringBuilder builder = new StringBuilder();
        builder.append(protoHead);
        this.protoJavaList.stream().sorted(Comparator.comparing(ProtoJava::getClassName)).map(ProtoJava::toProtoMessage).forEach(builder::append);
        return builder.toString();
    }

    public ProtoJavaRegion setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ProtoJavaRegion setFilePackage(String filePackage) {
        this.filePackage = filePackage;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePackage() {
        return this.filePackage;
    }

    public Map<Class<?>, ProtoJava> getProtoJavaMap() {
        return this.protoJavaMap;
    }

    public List<ProtoJava> getProtoJavaList() {
        return this.protoJavaList;
    }

    public ProtoJavaRegionHead getRegionHead() {
        return this.regionHead;
    }

    static class ProtoJavaRegionHead {
        Set<String> fileNameSet = new HashSet<String>();
        String filePackage;

        ProtoJavaRegionHead() {
        }

        private String toProtoHead() {
            String templateFileName = "import \"{}\";\n";
            StringBuilder fileNameBuilder = new StringBuilder();
            for (String filePackage : this.fileNameSet) {
                String filePackageString = StrKit.format((CharSequence)templateFileName, (Object[])new Object[]{filePackage});
                fileNameBuilder.append(filePackageString);
            }
            String templateHead = "syntax = \"proto3\";\npackage {};\n{}\n";
            return StrKit.format((CharSequence)templateHead, (Object[])new Object[]{this.filePackage, fileNameBuilder.toString()});
        }
    }
}

