/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.protobuf;

import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.iohao.game.common.kit.ClassScanner;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.common.kit.io.FileKit;
import com.iohao.game.widget.light.protobuf.ProtoFieldTypeHolder;
import com.iohao.game.widget.light.protobuf.ProtoFileMerge;
import com.iohao.game.widget.light.protobuf.ProtoJava;
import com.iohao.game.widget.light.protobuf.ProtoJavaField;
import com.iohao.game.widget.light.protobuf.ProtoJavaRegion;
import com.iohao.game.widget.light.protobuf.ProtoJavaRegionKey;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoJavaAnalyse {
    private static final Logger log = LoggerFactory.getLogger(ProtoJavaAnalyse.class);
    final Map<ProtoJavaRegionKey, ProtoJavaRegion> protoJavaRegionMap = new HashMap<ProtoJavaRegionKey, ProtoJavaRegion>();
    final Map<Class<?>, ProtoJava> protoJavaMap = new HashMap();
    final Map<String, JavaClass> protoJavaSourceFileMap = new HashMap<String, JavaClass>();
    private final Predicate<Class<?>> predicateFilter = clazz -> {
        ProtobufClass annotation = clazz.getAnnotation(ProtobufClass.class);
        ProtoFileMerge protoFileMerge = clazz.getAnnotation(ProtoFileMerge.class);
        return Objects.nonNull(annotation) && Objects.nonNull(protoFileMerge);
    };

    public Map<ProtoJavaRegionKey, ProtoJavaRegion> analyse(String protoPackagePath, String protoSourcePath) {
        return this.analyse(protoPackagePath, protoSourcePath, this.predicateFilter);
    }

    public Map<ProtoJavaRegionKey, ProtoJavaRegion> analyse(String protoPackagePath, String protoSourcePath, Predicate<Class<?>> predicateFilter) {
        this.javaProjectBuilder(protoSourcePath);
        ClassScanner classScanner = new ClassScanner(protoPackagePath, predicateFilter);
        List classList = classScanner.listScan();
        if (classList.isEmpty()) {
            return this.protoJavaRegionMap;
        }
        List<ProtoJava> protoJavaList = this.convert(classList);
        for (ProtoJava protoJava : protoJavaList) {
            this.analyseField(protoJava);
        }
        return this.protoJavaRegionMap;
    }

    private void javaProjectBuilder(String protoSourcePath) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        javaProjectBuilder.addSourceTree(FileKit.file((String)protoSourcePath));
        Collection javaClassCollection = javaProjectBuilder.getClasses();
        for (JavaClass javaClass : javaClassCollection) {
            if (javaClass.getAnnotations().size() < 2) continue;
            this.protoJavaSourceFileMap.put(javaClass.toString(), javaClass);
            log.info("javaClass: {}", (Object)javaClass);
        }
    }

    private List<ProtoJava> convert(List<Class<?>> classList) {
        return classList.stream().map(clazz -> {
            ProtoFileMerge annotation = clazz.getAnnotation(ProtoFileMerge.class);
            String fileName = annotation.fileName();
            String filePackage = annotation.filePackage();
            JavaClass javaClass = this.protoJavaSourceFileMap.get(clazz.toString());
            ProtoJava protoJava = new ProtoJava().setClassName(clazz.getSimpleName()).setComment(javaClass.getComment()).setClazz((Class<?>)clazz).setFileName(fileName).setFilePackage(filePackage).setJavaClass(javaClass);
            this.protoJavaMap.put((Class<?>)clazz, protoJava);
            ProtoJavaRegionKey regionKey = new ProtoJavaRegionKey(fileName, filePackage);
            ProtoJavaRegion protoJavaRegion = this.getProtoJavaRegion(regionKey);
            protoJavaRegion.addProtoJava(protoJava);
            return protoJava;
        }).collect(Collectors.toList());
    }

    private void analyseField(ProtoJava protoJava) {
        int order;
        Field[] fields;
        Class<?> clazz = protoJava.getClazz();
        if (clazz.isEnum()) {
            Field[] enumFields = clazz.getDeclaredFields();
            ArrayList<Field> fieldList = new ArrayList<Field>(enumFields.length);
            Field[] fieldArray = enumFields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field enumField = fieldArray[i];
                if (Modifier.isPrivate(enumField.getModifiers())) continue;
                fieldList.add(enumField);
            }
            fields = new Field[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                fields[i] = (Field)fieldList.get(i);
            }
            order = 0;
        } else {
            fields = FieldAccess.get(clazz).getFields();
            order = 1;
        }
        JavaClass javaClass = protoJava.getJavaClass();
        for (Field field : fields) {
            String fieldName = field.getName();
            Class<?> fieldTypeClass = field.getType();
            boolean repeated = List.class.equals(fieldTypeClass);
            JavaField javaField = javaClass.getFieldByName(fieldName);
            ProtoJavaField protoJavaField = new ProtoJavaField().setRepeated(repeated).setFieldName(fieldName).setComment(javaField.getComment()).setOrder(order++).setFieldTypeClass(fieldTypeClass).setField(field).setProtoJavaParent(protoJava);
            protoJava.addProtoJavaFiled(protoJavaField);
            String fieldProtoType = ProtoFieldTypeHolder.me().getProtoType(fieldTypeClass);
            if (Objects.nonNull(fieldProtoType)) {
                protoJavaField.setFieldProtoType(fieldProtoType);
                continue;
            }
            if (protoJavaField.isMap()) {
                this.processMapFieldProtoJava(protoJavaField);
                continue;
            }
            if (protoJavaField.isList()) {
                this.processListFieldProtoJava(protoJavaField);
                continue;
            }
            this.processFieldProtoJava(protoJavaField);
        }
    }

    private String fieldProtoTypeToString(ProtoJavaField protoJavaField, Class<?> fieldTypeClass) {
        String fieldProtoType;
        String fieldName = protoJavaField.getFieldName();
        ProtoJava protoJavaFieldType = this.getFieldProtoJava(fieldTypeClass, fieldName, protoJavaField);
        ProtoJava protoJavaParent = protoJavaField.getProtoJavaParent();
        String filePackage = protoJavaFieldType.getFilePackage();
        String className = protoJavaFieldType.getClassName();
        if (protoJavaParent.inThisFile(protoJavaFieldType)) {
            fieldProtoType = className;
        } else {
            ProtoJavaRegionKey regionKey = protoJavaParent.getProtoJavaRegionKey();
            ProtoJavaRegion protoJavaRegion = this.getProtoJavaRegion(regionKey);
            protoJavaRegion.addOtherProtoFile(protoJavaFieldType);
            fieldProtoType = StrKit.format((CharSequence)"{}.{}", (Object[])new Object[]{filePackage, className});
        }
        return fieldProtoType;
    }

    private void processFieldProtoJava(ProtoJavaField protoJavaField) {
        Class<?> fieldTypeClass = protoJavaField.getFieldTypeClass();
        String fieldName = protoJavaField.getFieldName();
        if (Objects.isNull(protoJavaField.getComment())) {
            ProtoJava protoJavaFieldType = this.getFieldProtoJava(fieldTypeClass, fieldName, protoJavaField);
            protoJavaField.setComment(protoJavaFieldType.getComment());
        }
        String fieldProtoType = this.fieldProtoTypeToString(protoJavaField, fieldTypeClass);
        protoJavaField.setFieldProtoType(fieldProtoType);
    }

    private void processListFieldProtoJava(ProtoJavaField protoJavaField) {
        Field field = protoJavaField.getField();
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        Class firstClass = (Class)actualTypeArguments[0];
        String fieldProtoType = ProtoFieldTypeHolder.me().getProtoType(firstClass);
        if (Objects.isNull(fieldProtoType)) {
            fieldProtoType = this.fieldProtoTypeToString(protoJavaField, firstClass);
        }
        protoJavaField.setRepeated(true).setFieldProtoType(fieldProtoType);
    }

    private void processMapFieldProtoJava(ProtoJavaField protoJavaField) {
        HashMap<String, String> map = new HashMap<String, String>();
        Field field = protoJavaField.getField();
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        Class keyClass = (Class)actualTypeArguments[0];
        String keyFieldProtoType = ProtoFieldTypeHolder.me().getProtoType(keyClass);
        map.put("keyStr", keyFieldProtoType);
        if (Objects.isNull(keyFieldProtoType)) {
            String keyStr = this.fieldProtoTypeToString(protoJavaField, keyClass);
            map.put("keyStr", keyStr);
        }
        Class valueClass = (Class)actualTypeArguments[1];
        String valueFieldProtoType = ProtoFieldTypeHolder.me().getProtoType(valueClass);
        map.put("valueStr", valueFieldProtoType);
        if (Objects.isNull(valueFieldProtoType)) {
            String valueStr = this.fieldProtoTypeToString(protoJavaField, valueClass);
            map.put("valueStr", valueStr);
        }
        String fieldProtoType = StrKit.format((CharSequence)"map<{keyStr},{valueStr}>", map);
        protoJavaField.setFieldProtoType(fieldProtoType);
    }

    private ProtoJava getFieldProtoJava(Class<?> fieldTypeClass, String fieldName, ProtoJavaField protoJavaField) {
        if (!this.predicateFilter.test(fieldTypeClass)) {
            String templateErr = "{}.{} class type not is protobuf !\nclass must import annotation {}\nclass must import annotation {}\n";
            String errorMsg = StrKit.format((CharSequence)templateErr, (Object[])new Object[]{protoJavaField.getProtoJavaParent().getClassName(), fieldName, ProtobufClass.class, ProtoFileMerge.class});
            throw new RuntimeException(errorMsg);
        }
        return this.protoJavaMap.get(fieldTypeClass);
    }

    private ProtoJavaRegion getProtoJavaRegion(ProtoJavaRegionKey key) {
        ProtoJavaRegion protoJavaRegion = this.protoJavaRegionMap.get(key);
        if (Objects.isNull(protoJavaRegion)) {
            protoJavaRegion = new ProtoJavaRegion();
            if (Objects.isNull(protoJavaRegion = this.protoJavaRegionMap.putIfAbsent(key, protoJavaRegion))) {
                protoJavaRegion = this.protoJavaRegionMap.get(key);
            }
            protoJavaRegion.setFileName(key.fileName());
            protoJavaRegion.setFilePackage(key.filePackage());
        }
        return protoJavaRegion;
    }
}

