/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.protobuf;

import com.iohao.game.common.kit.StrKit;
import com.iohao.game.widget.light.protobuf.ProtoJavaField;
import com.iohao.game.widget.light.protobuf.ProtoJavaRegionKey;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProtoJava {
    private Class<?> clazz;
    private String className;
    private String comment;
    private String fileName;
    private String filePackage;
    private JavaClass javaClass;
    private List<ProtoJavaField> protoJavaFieldList = new ArrayList<ProtoJavaField>();

    public void addProtoJavaFiled(ProtoJavaField protoJavaField) {
        this.protoJavaFieldList.add(protoJavaField);
    }

    public boolean inThisFile(ProtoJava protoJava) {
        return Objects.equals(this.fileName, protoJava.fileName) && Objects.equals(this.filePackage, protoJava.filePackage);
    }

    public ProtoJavaRegionKey getProtoJavaRegionKey() {
        return new ProtoJavaRegionKey(this.fileName, this.filePackage);
    }

    public String toProtoMessage() {
        String fieldsString = this.protoJavaFieldList.stream().map(ProtoJavaField::toProtoFieldLine).collect(Collectors.joining("\n"));
        HashMap<String, String> messageMap = new HashMap<String, String>();
        messageMap.put("className", this.className);
        messageMap.put("fieldsString", fieldsString);
        messageMap.put("classComment", this.comment);
        messageMap.put("classOrEnum", this.clazz.isEnum() ? "enum" : "message");
        String template = "// {classComment}\n{classOrEnum} {className} {\n{fieldsString}\n}\n\n";
        return StrKit.format((CharSequence)template, messageMap);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePackage() {
        return this.filePackage;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    public List<ProtoJavaField> getProtoJavaFieldList() {
        return this.protoJavaFieldList;
    }

    public ProtoJava setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public ProtoJava setClassName(String className) {
        this.className = className;
        return this;
    }

    public ProtoJava setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ProtoJava setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ProtoJava setFilePackage(String filePackage) {
        this.filePackage = filePackage;
        return this;
    }

    public ProtoJava setJavaClass(JavaClass javaClass) {
        this.javaClass = javaClass;
        return this;
    }

    public ProtoJava setProtoJavaFieldList(List<ProtoJavaField> protoJavaFieldList) {
        this.protoJavaFieldList = protoJavaFieldList;
        return this;
    }
}

