/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.widget.light.protobuf;

import com.iohao.game.common.kit.StrKit;
import com.iohao.game.common.kit.io.FileKit;
import com.iohao.game.widget.light.protobuf.ProtoJava;
import com.iohao.game.widget.light.protobuf.ProtoJavaAnalyse;
import com.iohao.game.widget.light.protobuf.ProtoJavaRegion;
import com.iohao.game.widget.light.protobuf.ProtoJavaRegionKey;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoGenerateFile {
    private static final Logger log = LoggerFactory.getLogger(ProtoGenerateFile.class);
    String protoSourcePath;
    String protoPackagePath;
    String generateFolder;

    private void checked() {
        Objects.requireNonNull(this.protoSourcePath);
        Objects.requireNonNull(this.protoPackagePath);
        Objects.requireNonNull(this.generateFolder);
        FileKit.mkdir((String)this.generateFolder);
    }

    public void generate() {
        this.checked();
        ProtoJavaAnalyse analyse = new ProtoJavaAnalyse();
        Map<ProtoJavaRegionKey, ProtoJavaRegion> regionMap = analyse.analyse(this.protoPackagePath, this.protoSourcePath);
        Consumer<ProtoJavaRegion> javaRegionConsumer = javaRegion -> {
            String fileName = javaRegion.getFileName();
            List<ProtoJava> protoJavaList = javaRegion.getProtoJavaList();
            log.info("fileName: {} - {}", (Object)fileName, (Object)protoJavaList.size());
            String protoString = javaRegion.toProtoFile();
            log.info("-------------{}---------------------", (Object)fileName);
            log.info("{}", (Object)protoString);
            String protoFilePath = StrKit.format((CharSequence)"{}{}{}", (Object[])new Object[]{this.generateFolder, File.separator, fileName});
            FileKit.writeUtf8String((String)protoString, (String)protoFilePath);
        };
        regionMap.values().forEach(javaRegionConsumer);
    }

    ProtoGenerateFile(String protoSourcePath, String protoPackagePath, String generateFolder) {
        this.protoSourcePath = protoSourcePath;
        this.protoPackagePath = protoPackagePath;
        this.generateFolder = generateFolder;
    }

    public static ProtoGenerateFileBuilder builder() {
        return new ProtoGenerateFileBuilder();
    }

    public static class ProtoGenerateFileBuilder {
        private String protoSourcePath;
        private String protoPackagePath;
        private String generateFolder;

        ProtoGenerateFileBuilder() {
        }

        public ProtoGenerateFileBuilder protoSourcePath(String protoSourcePath) {
            this.protoSourcePath = protoSourcePath;
            return this;
        }

        public ProtoGenerateFileBuilder protoPackagePath(String protoPackagePath) {
            this.protoPackagePath = protoPackagePath;
            return this;
        }

        public ProtoGenerateFileBuilder generateFolder(String generateFolder) {
            this.generateFolder = generateFolder;
            return this;
        }

        public ProtoGenerateFile build() {
            return new ProtoGenerateFile(this.protoSourcePath, this.protoPackagePath, this.generateFolder);
        }

        public String toString() {
            return "ProtoGenerateFile.ProtoGenerateFileBuilder(protoSourcePath=" + this.protoSourcePath + ", protoPackagePath=" + this.protoPackagePath + ", generateFolder=" + this.generateFolder + ")";
        }
    }
}

