/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.user;

import com.iohao.game.common.kit.InternalKit;
import com.iohao.game.external.client.user.ClientUser;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUsers {
    private static final Logger log = LoggerFactory.getLogger(ClientUsers.class);
    static final BlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
    static final AtomicBoolean loginSuccess = new AtomicBoolean();
    static final List<ClientUser> clientUsers = new CopyOnWriteArrayList<ClientUser>();

    private static void extractedExecute() {
        InternalKit.execute(() -> {
            if (clientUsers.size() > 1) {
                log.info("{} \u4e2a\u73a9\u5bb6\u5168\u90e8\u767b\u5f55\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1[{}]", (Object)clientUsers.size(), (Object)runnableQueue.size());
            }
            try {
                while (true) {
                    Runnable take = runnableQueue.take();
                    InternalKit.execute((Runnable)take);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void addClientUser(ClientUser clientUser) {
        clientUsers.add(clientUser);
    }

    static boolean isLoginSuccess() {
        if (loginSuccess.get()) {
            return true;
        }
        int size = 0;
        for (ClientUser clientUser : clientUsers) {
            if (clientUser.getUserId() == 0L) continue;
            ++size;
        }
        loginSuccess.set(clientUsers.size() == size);
        return loginSuccess.get();
    }

    public static void execute(Runnable command) {
        runnableQueue.add(command);
    }

    private ClientUsers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        InternalKit.execute(() -> {
            boolean loginSuccess;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            while (!(loginSuccess = ClientUsers.isLoginSuccess())) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            ClientUsers.extractedExecute();
        });
    }
}

